/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.sms.util;

import com.pingidentity.pf.sms.SmsReceiverSettings;
import com.pingidentity.pf.sms.SmsSettings;
import com.twilio.Twilio;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.type.PhoneNumber;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMSProcessor
implements Runnable {
    private static final Log logger = LogFactory.getLog(SMSProcessor.class);
    private final SmsSettings smsSetting;
    private final SmsReceiverSettings receiverSettings;

    public SMSProcessor(SmsSettings smsSetting, SmsReceiverSettings receiverSettings) {
        this.smsSetting = smsSetting;
        this.receiverSettings = receiverSettings;
    }

    @Override
    public void run() {
        this.sendSMS();
    }

    public boolean sendSMS() {
        if (StringUtils.isEmpty((String)this.receiverSettings.getSendToNumber())) {
            logger.debug((Object)"Cannot send an SMS to blank number.");
            return false;
        }
        if (StringUtils.isEmpty((String)this.receiverSettings.getMessage())) {
            logger.debug((Object)("Empty message not sent to '" + this.receiverSettings.getSendToNumber() + "'."));
            return false;
        }
        Twilio.init((String)this.smsSetting.getSmsAccountId(), (String)this.smsSetting.getSmsAuthToken());
        String msgBody = this.receiverSettings.getMessage();
        try {
            Message.creator((PhoneNumber)new PhoneNumber(this.receiverSettings.getSendToNumber()), (PhoneNumber)new PhoneNumber(this.smsSetting.getFromNumber()), (String)msgBody).create();
            logger.debug((Object)("SMS sent to " + this.receiverSettings.getSendToNumber()));
        }
        catch (Exception ex) {
            logger.error((Object)"Error sending SMS message.", (Throwable)ex);
            return false;
        }
        return true;
    }
}

