/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci;

import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.integrations.logger.LogLevel;

public enum CustomLogEvent implements LogEvent
{
    INCONSISTENT_NONCE(LogLevel.DEBUG, "000", "Response is inconsistent: %s"),
    RESPONSE_NOT_SIGNED(LogLevel.WARN, "001", "Response from PingOne DaVinci is not signed."),
    RESPONSE_NOT_JSON(LogLevel.DEBUG, "002", "Response from PingOne DaVinci is not in JSON format."),
    RECEIVED_NON_SUCCESS_RESPONSE(LogLevel.DEBUG, "003", "PingOne DaVinci returned non success response. %s"),
    NO_SUBJECT(LogLevel.WARN, "004", "No subject returned from response."),
    PUBLIC_KEY_ERROR(LogLevel.DEBUG, "005", "Failed to get public keys from JWKS endpoint."),
    GET_ATTRIBUTES_ERROR(LogLevel.DEBUG, "006", "Failed to get attributes from flowResult: %s"),
    PARAMETER_EMPTY_ERROR(LogLevel.DEBUG, "007", "Failed to include parameter '%s' in parameters."),
    FLOW_RESPONSE_RECEIVED(LogLevel.DEBUG, "008", "Received flow response.\n %s"),
    BYPASS(LogLevel.DEBUG, "009", "Authentication bypassed due to adapter failure mode configuration."),
    EXCEPTION_THROWN(LogLevel.DEBUG, "010", "Exception thrown by the PingOne DaVinci Adapter."),
    HTTP_EXECUTE_ERROR(LogLevel.DEBUG, "011", "Unable to execute http request."),
    HTTP_RESPONSE_CODE(LogLevel.DEBUG, "012", "Http response code: %d"),
    REQUEST_ACCESS_TOKEN(LogLevel.DEBUG, "013", "Requesting access token."),
    ACCESS_TOKEN_ERROR(LogLevel.DEBUG, "014", "Error getting access token: %s"),
    FLOW_INVOCATION_ERROR(LogLevel.DEBUG, "020", "Error invoking flow: %s"),
    GET_JWKS(LogLevel.DEBUG, "015", "Get JWKS."),
    INVALID_CONTINUE_TOKEN(LogLevel.DEBUG, "016", "Continue token in request is invalid."),
    MISSING_RESUME_PATH(LogLevel.DEBUG, "017", "Missing resume path."),
    PARSE_JWT_ERROR(LogLevel.DEBUG, "018", "Error parsing signed JWT."),
    CONVERT_JSON_ERROR(LogLevel.DEBUG, "019", "Failed to convert to JSON object. %s");

    private static final String APP_MESSAGE_CODE = "IPDV";
    private final LogLevel level;
    private final String code;
    private final String message;

    private CustomLogEvent(LogLevel level, String code, String message) {
        this.level = level;
        this.code = code;
        this.message = message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return "IPDV-" + this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

