/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci;

import com.pingidentity.adapters.pingone.davinci.PingOneDaVinciAdapter;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;

public class PingOneDaVinciStateSupport {
    private static final String RESUME_URL = PingOneDaVinciAdapter.class.getName() + ".resumeUrl";
    private static final String CONTINUE_TOKEN = PingOneDaVinciAdapter.class.getName() + ".continueToken";
    private static final String NONCE = PingOneDaVinciAdapter.class.getName() + ".nonce";
    private final HttpServletRequest req;
    private final HttpServletResponse resp;
    private final TransactionalStateSupport transactionalStateSupport;

    public PingOneDaVinciStateSupport(HttpServletRequest req, HttpServletResponse resp, String resumePath) {
        this.req = req;
        this.resp = resp;
        this.transactionalStateSupport = new TransactionalStateSupport(resumePath);
    }

    public void setResumeUrl(String value) {
        this.transactionalStateSupport.setAttribute(RESUME_URL, (Object)value, this.req, this.resp);
    }

    public String getResumeUrl() {
        return (String)this.transactionalStateSupport.getAttribute(RESUME_URL, this.req, this.resp);
    }

    public void setContinueToken(String value) {
        this.transactionalStateSupport.setAttribute(CONTINUE_TOKEN, (Object)value, this.req, this.resp);
    }

    public String getContinueToken() {
        return (String)this.transactionalStateSupport.getAttribute(CONTINUE_TOKEN, this.req, this.resp);
    }

    public String setNonce() {
        String nonce = UUID.randomUUID().toString();
        this.transactionalStateSupport.setAttribute(NONCE, (Object)nonce, this.req, this.resp);
        return nonce;
    }

    public String getAndRemoveNonce() {
        String storedNonce = (String)this.transactionalStateSupport.getAttribute(NONCE, this.req, this.resp);
        this.removeAttribute(NONCE);
        return storedNonce;
    }

    private void removeAttribute(String name) {
        this.transactionalStateSupport.removeAttribute(name, this.req, this.resp);
    }

    public void cleanup() {
        this.removeAttribute(RESUME_URL);
        this.removeAttribute(CONTINUE_TOKEN);
    }
}

