/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.api;

import com.pingidentity.adapters.pingone.davinci.CustomLogEvent;
import com.pingidentity.adapters.pingone.davinci.exception.ApiException;
import com.pingidentity.adapters.pingone.davinci.shade.com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.adapters.pingone.davinci.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.adapters.pingone.davinci.util.ObjectMapperUtil;
import java.util.Map;

public abstract class ApiClient {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(ApiClient.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperUtil.getDefault();
    HttpService httpService;

    protected ApiClient(HttpService httpService) {
        this.httpService = httpService;
    }

    protected static GenericHttpBody getBody(Map<String, Object> values) {
        String body;
        try {
            body = OBJECT_MAPPER.writeValueAsString(values);
        }
        catch (JsonProcessingException e) {
            body = "";
        }
        return new GenericHttpBody(body, ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_JSON.getCharset().toString());
    }

    protected GenericHttpResponse executeRequest(GenericHttpRequest request) throws ApiException {
        GenericHttpResponse genericHttpResponse;
        try {
            genericHttpResponse = this.httpService.execute(request);
        }
        catch (HttpServiceException e) {
            LOGGER.log(CustomLogEvent.HTTP_EXECUTE_ERROR);
            throw new ApiException("Unable to execute request", e);
        }
        LOGGER.log((LogEvent)CustomLogEvent.HTTP_RESPONSE_CODE, genericHttpResponse.getStatusCode());
        return genericHttpResponse;
    }
}

