/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.api;

import com.pingidentity.adapters.pingone.davinci.CustomLogEvent;
import com.pingidentity.adapters.pingone.davinci.api.ApiClient;
import com.pingidentity.adapters.pingone.davinci.exception.ApiException;
import com.pingidentity.adapters.pingone.davinci.model.PingOneDaVinciData;
import com.pingidentity.adapters.pingone.davinci.model.TokenResponse;
import com.pingidentity.adapters.pingone.davinci.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpQueryParams;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jwk.JsonWebKeySet;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.JoseException;
import com.pingidentity.adapters.pingone.davinci.shade.org.json.simple.JSONObject;
import com.pingidentity.adapters.pingone.davinci.shade.org.json.simple.parser.JSONParser;
import com.pingidentity.adapters.pingone.davinci.shade.org.json.simple.parser.ParseException;
import com.pingidentity.adapters.pingone.davinci.util.ObjectMapperUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PingOneDaVinciClient
extends ApiClient {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(PingOneDaVinciClient.class);
    private static final String TOKEN_URL_TEMPLATE = "%s/v1/company/%s/sdktoken";
    private static final String START_URL_TEMPLATE = "%s/v1/company/%s/policy/%s/start";
    private static final String JWKS_URL = "%s/davinci/.well-known/jwks.json";
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperUtil.getDefault();
    private static final JSONParser PARSER = new JSONParser();
    private final String tokenUrl;
    private final String startUrl;
    private final String jwkUrl;
    private final String apiKey;
    private final String policyId;

    public PingOneDaVinciClient(HttpService httpService, PingOneDaVinciData pingOneDaVinciData) {
        super(httpService);
        this.tokenUrl = String.format(TOKEN_URL_TEMPLATE, pingOneDaVinciData.getApiUrl(), pingOneDaVinciData.getCompanyId());
        this.startUrl = String.format(START_URL_TEMPLATE, pingOneDaVinciData.getApiUrl(), pingOneDaVinciData.getCompanyId(), pingOneDaVinciData.getPolicyId());
        this.jwkUrl = this.getJwksUrl(pingOneDaVinciData);
        this.apiKey = pingOneDaVinciData.getApiKey();
        this.policyId = pingOneDaVinciData.getPolicyId();
    }

    private String getJwksUrl(PingOneDaVinciData pingOneDaVinciData) {
        String authUrl = pingOneDaVinciData.getAuthUrl();
        Pattern prodAuthPattern = Pattern.compile("https:\\/\\/auth\\.pingone\\.(.+)");
        Pattern nonProdAuthPattern = Pattern.compile("https:\\/\\/auth-(.+)\\.pingone\\.com");
        Matcher prodMatcher = prodAuthPattern.matcher(authUrl);
        Matcher nonProdMatcher = nonProdAuthPattern.matcher(authUrl);
        String baseUrl = authUrl;
        if (prodMatcher.find() | nonProdMatcher.find()) {
            String companyId = "/" + pingOneDaVinciData.getCompanyId();
            baseUrl = baseUrl + companyId;
        }
        return String.format(JWKS_URL, baseUrl, pingOneDaVinciData.getCompanyId());
    }

    public String postTokenRequest(JSONObject parameters) throws ApiException {
        try {
            LOGGER.log(CustomLogEvent.REQUEST_ACCESS_TOKEN);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", ContentType.APPLICATION_JSON.toString());
            header.put("X-SK-API-KEY", this.apiKey);
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("policyId", this.policyId);
            body.put("parameters", parameters);
            GenericHttpRequest request = new GenericHttpRequest(GenericHttpMethod.POST, this.tokenUrl, new GenericHttpQueryParams(), new GenericHttpHeaders(header), PingOneDaVinciClient.getBody(body));
            GenericHttpResponse genericHttpResponse = this.executeRequest(request);
            String response = genericHttpResponse.getBody().getContent();
            if (genericHttpResponse.getStatusCode() != 200) {
                JSONObject responseObj = (JSONObject)PARSER.parse(response);
                String errorMessage = (String)responseObj.get("errorMessage");
                if (errorMessage == null) {
                    errorMessage = "get token response is not 200";
                }
                throw new ApiException(errorMessage);
            }
            TokenResponse tokenResponse = OBJECT_MAPPER.readValue(response, TokenResponse.class);
            if (!tokenResponse.getSuccess()) {
                throw new ApiException("service returned failure");
            }
            return tokenResponse.getAccessToken();
        }
        catch (ApiException | ParseException | IOException e) {
            String errorMsg = e.getMessage();
            if (e instanceof ParseException) {
                errorMsg = "failed to parse non 200 response";
            }
            LOGGER.log((LogEvent)CustomLogEvent.ACCESS_TOKEN_ERROR, errorMsg);
            throw new ApiException("Error getting access token: " + errorMsg, e);
        }
    }

    public JwksVerificationKeyResolver getJwksResolver() {
        try {
            LOGGER.log(CustomLogEvent.GET_JWKS);
            GenericHttpRequest request = new GenericHttpRequest(GenericHttpMethod.GET, this.jwkUrl);
            GenericHttpResponse genericHttpResponse = this.executeRequest(request);
            String response = genericHttpResponse.getBody().getContent();
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(response);
            return new JwksVerificationKeyResolver(jsonWebKeySet.getJsonWebKeys());
        }
        catch (ApiException | JoseException e) {
            return null;
        }
    }

    public String invokeFlow(JSONObject parameters) throws ApiException {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        header.put("X-SK-API-KEY", this.apiKey);
        GenericHttpRequest request = new GenericHttpRequest(GenericHttpMethod.POST, this.startUrl, new GenericHttpQueryParams(), new GenericHttpHeaders(header), new GenericHttpBody(parameters.toJSONString(), ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_JSON.getCharset().toString()));
        try {
            GenericHttpResponse genericHttpResponse = this.executeRequest(request);
            return genericHttpResponse.getBody().getContent();
        }
        catch (ApiException e) {
            String errorMsg = e.getMessage();
            LOGGER.log((LogEvent)CustomLogEvent.FLOW_INVOCATION_ERROR, errorMsg);
            throw new ApiException("Error invoking flow: " + errorMsg, e);
        }
    }
}

