/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.configuration;

import com.pingidentity.adapters.pingone.davinci.configuration.ConfigurationField;
import com.pingidentity.adapters.pingone.davinci.model.AdvancedParameterType;
import com.pingidentity.adapters.pingone.davinci.model.ParameterMapping;
import com.pingidentity.adapters.pingone.davinci.model.SimpleParameterType;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.util.JsonPointerValidator;
import com.pingidentity.adapters.pingone.davinci.validator.ParameterNameValidator;
import com.pingidentity.adapters.pingone.davinci.validator.ParameterTableValidator;
import com.pingidentity.adapters.pingone.davinci.validator.SlashPrefixValidator;
import com.pingidentity.adapters.pingone.davinci.validator.TableUniqueKeyValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class AdapterConfiguration {
    static FieldValidator required = new RequiredFieldValidator();

    private AdapterConfiguration() {
    }

    public static AdapterConfigurationGuiDescriptor makeAdapterConfigurationGuiDescription() {
        AdapterConfigurationGuiDescriptor adapterConf = new AdapterConfigurationGuiDescriptor();
        adapterConf.setDescription(ConfigurationField.ADAPTER.getDescription());
        adapterConf.addTable((TableDescriptor)new SimpleParameterTable());
        adapterConf.addTable((TableDescriptor)new AdvancedParameterTable());
        adapterConf.addTable((TableDescriptor)new ResponseMappingsTable());
        adapterConf.addField((FieldDescriptor)new CustomTextField(ConfigurationField.COMPANY_ID, required));
        adapterConf.addField((FieldDescriptor)new CustomTextField(ConfigurationField.POLICY_ID, required));
        adapterConf.addField((FieldDescriptor)new CustomRadioField(ConfigurationField.FLOW_TYPE, "Widget-based flow", "API-based flow"));
        adapterConf.addField((FieldDescriptor)new CustomTextField(ConfigurationField.API_KEY, true, required));
        adapterConf.addField((FieldDescriptor)new CustomTextField(ConfigurationField.SUBJECT_ATTR_PATH, new SlashPrefixValidator()));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.ADDITIONAL_PROPERTIES_ATTRIBUTE, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.NONCE_ATTR_PATH, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.HTML_TEMPLATE, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.MESSAGE_PROPERTIES, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.API_URL, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.AUTH_URL, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.WIDGET_URL, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.CALLBACK_ENDPOINT, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomRadioField(ConfigurationField.SERVICE_UNAVAILABLE_FAILURE_MODE, "Block user", "Bypass authentication"));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.API_REQUEST_TIMEOUT, new FieldValidator[]{required, new IntegerValidator(0, Integer.MAX_VALUE)}));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomRadioField(ConfigurationField.PROXY_SETTINGS, "No Proxy", "System Defaults", "Custom"));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(ConfigurationField.PROXY_HOST, new FieldValidator[0]));
        CustomTextField proxyPortField = new CustomTextField(ConfigurationField.PROXY_PORT, new FieldValidator[0]);
        proxyPortField.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        adapterConf.addAdvancedField((FieldDescriptor)proxyPortField);
        adapterConf.addValidator((ConfigurationValidator)new ParameterTableValidator());
        return adapterConf;
    }

    public static String getStringValue(Configuration configuration, ConfigurationField config) {
        String value = configuration.getFieldValue(config.getField());
        return value != null ? value.trim() : null;
    }

    public static int getIntValue(Configuration configuration, ConfigurationField config) {
        return configuration.getIntFieldValue(config.getField());
    }

    public static List<ParameterMapping> getSimpleParameterMappings(Configuration configuration) {
        Table table = configuration.getTable(ConfigurationField.SIMPLE_PARAMETER_MAPPINGS_TABLE.getField());
        if (table != null) {
            return table.getRows().stream().map(row -> new ParameterMapping(SimpleParameterTable.getDaVinciParameterName(row), SimpleParameterTable.getSource(row), null)).collect(Collectors.toList());
        }
        return new ArrayList<ParameterMapping>();
    }

    public static List<ParameterMapping> getAdvancedParameterMappings(Configuration configuration) {
        Table table = configuration.getTable(ConfigurationField.ADVANCED_PARAMETER_MAPPINGS_TABLE.getField());
        if (table != null) {
            return table.getRows().stream().map(row -> new ParameterMapping(AdvancedParameterTable.getDaVinciParameterName(row), AdvancedParameterTable.getSourceType(row), AdvancedParameterTable.getSourceParameter(row))).collect(Collectors.toList());
        }
        return new ArrayList<ParameterMapping>();
    }

    public static Map<String, String> getResponseMappings(Configuration configuration) {
        Table table = configuration.getTable(ConfigurationField.RESPONSE_MAPPINGS_TABLE.getField());
        if (table != null) {
            return table.getRows().stream().collect(Collectors.toMap(x$0 -> ResponseMappingsTable.getLocalAttribute(x$0), x$0 -> ResponseMappingsTable.getLocalAttributeMapping(x$0)));
        }
        return new HashMap<String, String>();
    }

    public static class ResponseMappingsTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new CustomTextField(ConfigurationField.LOCAL_ATTRIBUTE, required), new CustomTextField(ConfigurationField.LOCAL_ATTRIBUTE_MAPPING, new JsonPointerValidator())});

        private ResponseMappingsTable() {
            super(ConfigurationField.RESPONSE_MAPPINGS_TABLE.getField(), ConfigurationField.RESPONSE_MAPPINGS_TABLE.getDescription(), ROW);
            this.addValidator((RowValidator)new TableUniqueKeyValidator(ConfigurationField.RESPONSE_MAPPINGS_TABLE.getField(), ConfigurationField.LOCAL_ATTRIBUTE.getField()));
        }

        private static String getLocalAttribute(Row row) {
            return row.getFieldValue(ConfigurationField.LOCAL_ATTRIBUTE.getField());
        }

        private static String getLocalAttributeMapping(Row row) {
            return row.getFieldValue(ConfigurationField.LOCAL_ATTRIBUTE_MAPPING.getField());
        }
    }

    public static class AdvancedParameterTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new CustomTextField(ConfigurationField.DAVINCI_PARAMETER_NAME, required, new ParameterNameValidator()), new AdvancedParameterTypeField(), new CustomTextField(ConfigurationField.SOURCE_PARAMETER, new FieldValidator[0])});

        private AdvancedParameterTable() {
            super(ConfigurationField.ADVANCED_PARAMETER_MAPPINGS_TABLE.getField(), ConfigurationField.ADVANCED_PARAMETER_MAPPINGS_TABLE.getDescription(), ROW);
        }

        private static String getDaVinciParameterName(Row row) {
            return row.getFieldValue(ConfigurationField.DAVINCI_PARAMETER_NAME.getField());
        }

        private static String getSourceType(Row row) {
            return row.getFieldValue(ConfigurationField.SOURCE_TYPE.getField());
        }

        private static String getSourceParameter(Row row) {
            return row.getFieldValue(ConfigurationField.SOURCE_PARAMETER.getField());
        }

        private static class AdvancedParameterTypeField
        extends SelectFieldDescriptor {
            private static final List<AbstractSelectionFieldDescriptor.OptionValue> OPTION_VALUES = AdvancedParameterTypeField.getOptions();

            private AdvancedParameterTypeField() {
                super(ConfigurationField.SOURCE_TYPE.getField(), ConfigurationField.SOURCE_TYPE.getDescription(), OPTION_VALUES);
                this.addValidator(required);
            }

            private static List<AbstractSelectionFieldDescriptor.OptionValue> getOptions() {
                ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
                options.add(SelectFieldDescriptor.SELECT_ONE);
                options.addAll(Arrays.stream(AdvancedParameterType.values()).map(AdvancedParameterTypeField::getOptionValue).collect(Collectors.toList()));
                return options;
            }

            private static AbstractSelectionFieldDescriptor.OptionValue getOptionValue(AdvancedParameterType advancedParameterType) {
                return new AbstractSelectionFieldDescriptor.OptionValue(advancedParameterType.getName(), advancedParameterType.getValue());
            }
        }
    }

    public static class SimpleParameterTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new CustomTextField(ConfigurationField.DAVINCI_PARAMETER_NAME, required, new ParameterNameValidator()), new SimpleParameterTypeField()});

        private SimpleParameterTable() {
            super(ConfigurationField.SIMPLE_PARAMETER_MAPPINGS_TABLE.getField(), ConfigurationField.SIMPLE_PARAMETER_MAPPINGS_TABLE.getDescription(), ROW);
        }

        private static String getDaVinciParameterName(Row row) {
            return row.getFieldValue(ConfigurationField.DAVINCI_PARAMETER_NAME.getField());
        }

        private static String getSource(Row row) {
            return row.getFieldValue(ConfigurationField.SOURCE.getField());
        }

        private static class SimpleParameterTypeField
        extends SelectFieldDescriptor {
            private static final List<AbstractSelectionFieldDescriptor.OptionValue> OPTION_VALUES = SimpleParameterTypeField.getOptions();

            private SimpleParameterTypeField() {
                super(ConfigurationField.SOURCE.getField(), ConfigurationField.SOURCE.getDescription(), OPTION_VALUES);
                this.addValidator(required);
            }

            private static List<AbstractSelectionFieldDescriptor.OptionValue> getOptions() {
                ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
                options.add(SelectFieldDescriptor.SELECT_ONE);
                options.addAll(Arrays.stream(SimpleParameterType.values()).map(SimpleParameterTypeField::getOptionValue).collect(Collectors.toList()));
                return options;
            }

            private static AbstractSelectionFieldDescriptor.OptionValue getOptionValue(SimpleParameterType simpleParameterType) {
                return new AbstractSelectionFieldDescriptor.OptionValue(simpleParameterType.getName(), simpleParameterType.getValue());
            }
        }
    }

    public static class CustomRadioField
    extends RadioGroupFieldDescriptor {
        public CustomRadioField(ConfigurationField config, String ... args) {
            super(config.getField(), config.getDescription(), args);
            this.setDefaultValue(config.getDefaultValue());
            this.setDefaultForLegacyConfig(config.getDefaultValue());
        }
    }

    public static class CustomTextField
    extends TextFieldDescriptor {
        public CustomTextField(ConfigurationField config, FieldValidator ... listOfValidator) {
            super(config.getField(), config.getDescription());
            this.setDefaultValue(config.getDefaultValue());
            if (listOfValidator.length != 0) {
                for (FieldValidator validator : listOfValidator) {
                    this.addValidator(validator);
                }
            }
        }

        public CustomTextField(ConfigurationField config, boolean masked, FieldValidator ... listOfValidator) {
            super(config.getField(), config.getDescription(), masked);
            if (listOfValidator.length != 0) {
                for (FieldValidator validator : listOfValidator) {
                    this.addValidator(validator);
                }
            }
        }
    }
}

