/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.configuration;

public enum ConfigurationField {
    ADAPTER("PingOne DaVinci IdP Adapter 1.3", "The PingOne DaVinci IdP Adapter allows PingFederate administrators to embed DaVinci flows in the PingFederate authentication policy flow."),
    DAVINCI_PARAMETER_NAME("DaVinci Parameter Name", null),
    SOURCE("Source", null),
    SOURCE_TYPE("Source Type", null),
    SOURCE_PARAMETER("Source Parameter", null),
    SIMPLE_PARAMETER_MAPPINGS_TABLE("Simple Parameter Mappings (optional)", "You can send additional parameters to DaVinci. Click 'Add a new row ...' to add multiple entries. Select the source of the parameter with '" + SOURCE.getField() + "'. In '" + DAVINCI_PARAMETER_NAME.getField() + "', choose a name for the parameter that is sent to DaVinci."),
    ADVANCED_PARAMETER_MAPPINGS_TABLE("Advanced Parameter Mappings (optional)", "You can send additional custom parameters to DaVinci. Click 'Add a new row ...' to add multiple entries. Select the source of the parameter with '" + SOURCE_TYPE.getField() + "'. Enter a specific parameter name in '" + SOURCE_PARAMETER.getField() + "', or leave it blank to send all parameters of the type. In '" + DAVINCI_PARAMETER_NAME.getField() + "', choose a name for the parameter that is sent to DaVinci."),
    RESPONSE_MAPPINGS_TABLE("DaVinci Response Mappings (optional)", "Define local attributes and map them to a remote attribute using JSON Pointer (RFC 6901) syntax. Click 'Add a new row ...' to add multiple entries."),
    LOCAL_ATTRIBUTE("Local Attribute", null),
    LOCAL_ATTRIBUTE_MAPPING("DaVinci Attribute Mapping", null),
    COMPANY_ID("Company ID", "Your DaVinci company ID."),
    POLICY_ID("Policy ID", "Your DaVinci flow policy ID."),
    FLOW_TYPE("Flow Type", "Determines whether the adapter presents the DaVinci Widget for user interaction. If your DaVinci flow redirects the browser or presents any user-facing screens, select Widget-based. Otherwise, select API-based to improve performance.", "Widget-based flow"),
    API_KEY("API Key", "Your DaVinci API key."),
    SUBJECT_ATTR_PATH("Subject Attribute Path", "The attribute from PingOne DaVinci to use as the subject in the contract. Map using JSON Pointer (RFC 6901) syntax."),
    ADDITIONAL_PROPERTIES_ATTRIBUTE("Additional Properties Attribute", "Name of the attribute that contains the additional properties from DaVinci.", "additionalProperties"),
    NONCE_ATTR_PATH("Nonce Attribute Path", "The attribute sent back from PingOne DaVinci for nonce validation. Map using JSON Pointer (RFC 6901) syntax.\nThe default value is '/parameters/nonce'.", "/parameters/nonce"),
    HTML_TEMPLATE("HTML Template", "Identifies the HTML template that the adapter uses. If you customized the template file name in '/server/default/conf/template', enter the new name here.\nThe default value is 'pingone-davinci.html'.", "pingone-davinci.html"),
    MESSAGE_PROPERTIES("Messages File", "Identifies the customizable language-pack file that the adapter uses.\nIf you customized the language-pack file name in '/server/default/conf/language-packs', enter the new name here.\nThe default value is 'pingone-davinci-messages'.", "pingone-davinci-messages"),
    API_URL("DaVinci API URL", "The DaVinci API base URL. The default URL is 'https://orchestrate-api.pingone.com'.", "https://orchestrate-api.pingone.com"),
    AUTH_URL("DaVinci Auth URL", "The DaVinci Auth base URL. The default URL is 'https://auth.pingone.com'.", "https://auth.pingone.com"),
    WIDGET_URL("DaVinci Widget URL", "The DaVinci Widget JS URL. The default URL is 'https://assets.pingone.com/davinci/latest/davinci.js'.", "https://assets.pingone.com/davinci/latest/davinci.js"),
    CALLBACK_ENDPOINT("Authorization Callback Endpoint", "The PingFederate endpoint that DaVinci uses to respond to authorization requests.\nNote: The 'Application Return To URL' setting in the DaVinci connector configuration is <PingFederate Base URL>/ext/<Authorization Callback Endpoint>.The default value is '/davinci-authn'.", "/davinci-authn"),
    SERVICE_UNAVAILABLE_FAILURE_MODE("Service Unavailable Failure Mode", "Determines whether the adapter should block the user's sign-on attempt or bypass when the adapter is unable to access PingOne.", "Block user"),
    API_REQUEST_TIMEOUT("API Request Timeout", "The amount of time in milliseconds that PingFederate waits for PingOne to respond to requests and connection establishment. The default value is 5000. A value of 0 disables the timeout.", "5000"),
    PROXY_SETTINGS("Proxy Settings", "Defines proxy settings for outbound HTTP requests.", "System Defaults"),
    PROXY_HOST("Custom Proxy Host", "The proxy server hostname to use when " + ConfigurationField.PROXY_SETTINGS.field + " is set to " + "Custom" + "."),
    PROXY_PORT("Custom Proxy Port", "The proxy server port to use when " + ConfigurationField.PROXY_SETTINGS.field + " is set to " + "Custom" + ".");

    private final String field;
    private final String description;
    private final String defaultValue;

    private ConfigurationField(String field, String description) {
        this.field = field;
        this.description = description;
        this.defaultValue = null;
    }

    private ConfigurationField(String field, String description, String defaultValue) {
        this.field = field;
        this.description = description;
        this.defaultValue = defaultValue;
    }

    public String getField() {
        return this.field;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

