/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.client5.http.impl;

import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.annotation.Internal;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.HttpMessage;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.ParseException;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.ProtocolException;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.ProtocolVersion;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.message.MessageSupport;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.ssl.TLS;
import java.util.Iterator;

@Internal
public final class ProtocolSwitchStrategy {
    public ProtocolVersion switchProtocol(HttpMessage response) throws ProtocolException {
        Iterator<String> it = MessageSupport.iterateTokens(response, "Upgrade");
        ProtocolVersion tlsUpgrade = null;
        while (it.hasNext()) {
            String token = it.next();
            if (token.startsWith("TLS")) {
                try {
                    tlsUpgrade = token.length() == 3 ? TLS.V_1_2.getVersion() : TLS.parse(token.replace("TLS/", "TLSv"));
                    continue;
                }
                catch (ParseException ex) {
                    throw new ProtocolException("Invalid protocol: " + token);
                }
            }
            if (token.equals("HTTP/1.1")) continue;
            throw new ProtocolException("Unsupported protocol: " + token);
        }
        if (tlsUpgrade == null) {
            throw new ProtocolException("Invalid protocol switch response");
        }
        return tlsUpgrade;
    }

    static enum ProtocolSwitch {
        FAILURE,
        TLS;

    }
}

