/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http2.impl.nio;

import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.concurrent.FutureCallback;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.function.Callback;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.ConnectionClosedException;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.EndpointDetails;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.HttpVersion;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.ProtocolVersion;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.http.nio.command.CommandSupport;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.io.CloseMode;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.reactor.IOSession;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.reactor.ssl.TlsDetails;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.util.Args;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSession;

abstract class PrefaceHandlerBase
implements HttpConnectionEventHandler {
    final ProtocolIOSession ioSession;
    private final AtomicReference<HttpConnectionEventHandler> protocolHandlerRef;
    private final FutureCallback<ProtocolIOSession> resultCallback;
    private final Callback<Exception> exceptionCallback;
    private final AtomicBoolean completed;

    PrefaceHandlerBase(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> resultCallback, Callback<Exception> exceptionCallback) {
        this.ioSession = Args.notNull(ioSession, "I/O session");
        this.protocolHandlerRef = new AtomicReference();
        this.resultCallback = resultCallback;
        this.exceptionCallback = exceptionCallback;
        this.completed = new AtomicBoolean();
    }

    void startProtocol(HttpConnectionEventHandler protocolHandler, ByteBuffer data) throws IOException {
        this.protocolHandlerRef.set(protocolHandler);
        this.ioSession.upgrade(protocolHandler);
        protocolHandler.connected(this.ioSession);
        if (data != null && data.hasRemaining()) {
            protocolHandler.inputReady(this.ioSession, data);
        }
        if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
            this.resultCallback.completed(this.ioSession);
        }
    }

    @Override
    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create(timeout));
    }

    @Override
    public void exception(IOSession session, Exception cause) {
        block6: {
            HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
            try {
                session.close(CloseMode.IMMEDIATE);
                if (protocolHandler != null) {
                    protocolHandler.exception(session, cause);
                } else {
                    CommandSupport.failCommands(session, cause);
                    if (this.exceptionCallback != null) {
                        this.exceptionCallback.execute(cause);
                    }
                }
            }
            catch (Exception ex) {
                if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
                    this.resultCallback.failed(ex);
                }
                if (this.exceptionCallback == null) break block6;
                this.exceptionCallback.execute(cause);
            }
        }
    }

    @Override
    public void disconnected(IOSession session) {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.getAndSet(null);
        try {
            if (protocolHandler != null) {
                protocolHandler.disconnected(this.ioSession);
            } else {
                CommandSupport.cancelCommands(session);
            }
        }
        finally {
            if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
                this.resultCallback.failed(new ConnectionClosedException());
            }
        }
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.ioSession.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }
}

