/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jws;

import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jca.ProviderContext;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jwa.AlgorithmInfo;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jwa.CryptoPrimitive;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jws.JsonWebSignatureAlgorithm;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.keys.KeyPersuasion;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.ExceptionHelp;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.JoseException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSignatureAlgorithm
extends AlgorithmInfo
implements JsonWebSignatureAlgorithm {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AlgorithmParameterSpec algorithmParameterSpec;

    public BaseSignatureAlgorithm(String id, String javaAlgo, String keyAlgo) {
        this.setAlgorithmIdentifier(id);
        this.setJavaAlgorithm(javaAlgo);
        this.setKeyPersuasion(KeyPersuasion.ASYMMETRIC);
        this.setKeyType(keyAlgo);
    }

    protected void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    @Override
    public boolean verifySignature(byte[] signatureBytes, Key key, byte[] securedInputBytes, ProviderContext providerContext) throws JoseException {
        Signature signature = this.getSignature(providerContext);
        this.initForVerify(signature, key);
        try {
            signature.update(securedInputBytes);
            return signature.verify(signatureBytes);
        }
        catch (SignatureException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Problem verifying " + this.getAlgorithmIdentifier() + " signature: " + ExceptionHelp.toStringWithCauses(e));
            }
            return false;
        }
    }

    @Override
    public CryptoPrimitive prepareForSign(Key key, ProviderContext providerContext) throws JoseException {
        Signature signature = this.getSignature(providerContext);
        this.initForSign(signature, key, providerContext);
        return new CryptoPrimitive(signature);
    }

    @Override
    public byte[] sign(CryptoPrimitive cryptoPrimitive, byte[] securedInputBytes) throws JoseException {
        Signature signature = cryptoPrimitive.getSignature();
        try {
            signature.update(securedInputBytes);
            return signature.sign();
        }
        catch (SignatureException e) {
            throw new JoseException("Problem creating signature.", e);
        }
    }

    private void initForSign(Signature signature, Key key, ProviderContext providerContext) throws com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException {
        try {
            PrivateKey privateKey = (PrivateKey)key;
            SecureRandom secureRandom = providerContext.getSecureRandom();
            if (secureRandom == null) {
                signature.initSign(privateKey);
            } else {
                signature.initSign(privateKey, secureRandom);
            }
        }
        catch (InvalidKeyException e) {
            throw new com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException(this.getBadKeyMessage(key) + "for " + this.getJavaAlgorithm(), e);
        }
    }

    private void initForVerify(Signature signature, Key key) throws com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException {
        try {
            PublicKey publicKey = (PublicKey)key;
            signature.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException(this.getBadKeyMessage(key) + "for " + this.getJavaAlgorithm(), e);
        }
    }

    private String getBadKeyMessage(Key key) {
        String msg = key == null ? "key is null" : "algorithm=" + key.getAlgorithm();
        return "The given key (" + msg + ") is not valid ";
    }

    private Signature getSignature(ProviderContext providerContext) throws JoseException {
        ProviderContext.Context suppliedKeyProviderContext = providerContext.getSuppliedKeyProviderContext();
        String sigProvider = suppliedKeyProviderContext.getSignatureProvider();
        String javaAlg = this.getJavaAlgorithm();
        ProviderContext.SignatureAlgorithmOverride algOverride = suppliedKeyProviderContext.getSignatureAlgorithmOverride();
        if (algOverride != null && algOverride.getAlgorithmName() != null) {
            javaAlg = algOverride.getAlgorithmName();
        }
        try {
            Signature signature;
            block9: {
                signature = sigProvider == null ? Signature.getInstance(javaAlg) : Signature.getInstance(javaAlg, sigProvider);
                AlgorithmParameterSpec algorithmParameterSpec = this.algorithmParameterSpec;
                if (algOverride != null) {
                    algorithmParameterSpec = algOverride.getAlgorithmParameterSpec();
                }
                if (algorithmParameterSpec != null) {
                    try {
                        signature.setParameter(algorithmParameterSpec);
                    }
                    catch (UnsupportedOperationException e) {
                        if (!this.log.isDebugEnabled()) break block9;
                        this.log.debug("Unable to set algorithm parameter spec on Signature (java algorithm name: " + javaAlg + ") so ignoring the UnsupportedOperationException and relying on the default parameters.", (Throwable)e);
                    }
                }
            }
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new JoseException("Unable to get an implementation of algorithm name: " + javaAlg, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new JoseException("Invalid algorithm parameter (" + this.algorithmParameterSpec + ") for: " + javaAlg, e);
        }
        catch (NoSuchProviderException e) {
            throw new JoseException("Unable to get an implementation of " + javaAlg + " for provider " + sigProvider, e);
        }
    }

    public abstract void validatePrivateKey(PrivateKey var1) throws com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException;

    @Override
    public void validateSigningKey(Key key) throws com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException {
        this.checkForNullKey(key);
        try {
            this.validatePrivateKey((PrivateKey)key);
        }
        catch (ClassCastException e) {
            throw new com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException(this.getBadKeyMessage(key) + "(not a private key or is the wrong type of key) for " + this.getJavaAlgorithm() + " / " + this.getAlgorithmIdentifier() + " " + e);
        }
    }

    public abstract void validatePublicKey(PublicKey var1) throws com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException;

    @Override
    public void validateVerificationKey(Key key) throws com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException {
        this.checkForNullKey(key);
        try {
            this.validatePublicKey((PublicKey)key);
        }
        catch (ClassCastException e) {
            throw new com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException(this.getBadKeyMessage(key) + "(not a public key or is the wrong type of key) for " + this.getJavaAlgorithm() + "/" + this.getAlgorithmIdentifier() + " " + e);
        }
    }

    private void checkForNullKey(Key key) throws com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException {
        if (key == null) {
            throw new com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.lang.InvalidKeyException("Key cannot be null");
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            Signature signature = this.getSignature(new ProviderContext());
            return signature != null;
        }
        catch (Exception e) {
            this.log.debug(this.getAlgorithmIdentifier() + " via " + this.getJavaAlgorithm() + " is NOT available from the underlying JCE (" + ExceptionHelp.toStringWithCauses(e) + ").");
            return false;
        }
    }
}

