/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.util;

import com.pingidentity.adapters.pingone.davinci.CustomLogEvent;
import com.pingidentity.adapters.pingone.davinci.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.davinci.shade.com.pingidentity.util.JsonPointerUtil;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jwa.AlgorithmConstraints;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jwt.consumer.InvalidJwtException;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jwt.consumer.JwtConsumer;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.jwt.consumer.JwtConsumerBuilder;
import com.pingidentity.adapters.pingone.davinci.shade.org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import com.pingidentity.adapters.pingone.davinci.util.ObjectMapperUtil;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class JwtUtil {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(JwtUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperUtil.getDefault();

    private JwtUtil() {
    }

    public static Map<String, AttributeValue> getAdditionalResponse(JwksVerificationKeyResolver jwksResolver, String signedResponse, Map<String, String> additionalResponseMappings) {
        try {
            AlgorithmConstraints jwsAlgConstraints = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, "RS256");
            if (jwksResolver == null) {
                LOGGER.log(CustomLogEvent.PUBLIC_KEY_ERROR);
                return new HashMap<String, AttributeValue>();
            }
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setVerificationKeyResolver(jwksResolver).setJwsAlgorithmConstraints(jwsAlgConstraints).build();
            JwtClaims jwtClaims = jwtConsumer.processToClaims(signedResponse);
            return JsonPointerUtil.mapResponse(OBJECT_MAPPER, additionalResponseMappings, jwtClaims.toJson());
        }
        catch (InvalidJwtException e) {
            LOGGER.log(CustomLogEvent.PARSE_JWT_ERROR);
            return new HashMap<String, AttributeValue>();
        }
    }
}

