/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.davinci.validator;

import com.pingidentity.adapters.pingone.davinci.configuration.AdapterConfiguration;
import com.pingidentity.adapters.pingone.davinci.configuration.ConfigurationField;
import com.pingidentity.adapters.pingone.davinci.shade.org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class ProxyConfigurationValidator
implements ConfigurationValidator {
    public void validate(Configuration configuration) throws ValidationException {
        String proxySettings = AdapterConfiguration.getStringValue(configuration, ConfigurationField.PROXY_SETTINGS);
        if ("Custom".equals(proxySettings)) {
            String proxyHost = AdapterConfiguration.getStringValue(configuration, ConfigurationField.PROXY_HOST);
            int proxyPort = AdapterConfiguration.getIntValue(configuration, ConfigurationField.PROXY_PORT);
            if (StringUtils.isBlank(proxyHost) && proxyPort == 0) {
                throw new ValidationException("'" + ConfigurationField.PROXY_HOST.getField() + "' and '" + ConfigurationField.PROXY_PORT.getField() + "' are required if the proxy mode is '" + "Custom" + "'.");
            }
            if (StringUtils.isBlank(proxyHost)) {
                throw new ValidationException("'" + ConfigurationField.PROXY_HOST.getField() + "' is required if the proxy mode is '" + "Custom" + "'.");
            }
            if (proxyPort == 0) {
                throw new ValidationException("'" + ConfigurationField.PROXY_PORT.getField() + "' is required if the proxy mode is '" + "Custom" + "'.");
            }
        }
    }
}

