/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.anttask;

import com.pingidentity.sdk.AdapterSelector;
import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailProcessor;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.notification.NotificationPublisherPlugin;
import com.pingidentity.sdk.oauth20.registration.DynamicClientRegistrationPlugin;
import com.pingidentity.sdk.oobauth.OOBAuthPlugin;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.provision.IdentityStoreProvisionerWithFiltering;
import com.pingidentity.sdk.secretmanager.SecretManager;
import com.pingidentity.sources.CustomDataSourceDriver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.ClasspathUtils;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.adapter.sp.authn.SpAuthenticationAdapter;
import org.sourceid.wstrust.plugin.generate.TokenGenerator;
import org.sourceid.wstrust.plugin.process.TokenProcessor;

public class BuildSdkDeploymentDesc
extends Task {
    private static final char DOT = '.';
    private static final String DOT_CLASS = ".class";
    private String classesDir;
    private String classpathRef;

    public String getClassesDir() {
        return this.classesDir;
    }

    public void setClassesDir(String classesDir) {
        this.classesDir = classesDir;
    }

    public String getClasspathRef() {
        return this.classpathRef;
    }

    public void setClasspathRef(String classpathRef) {
        this.classpathRef = classpathRef;
    }

    public void execute() throws BuildException {
        Path path = new Path(this.getProject(), this.classesDir);
        Object reference = this.getProject().getReference(this.classpathRef);
        path.add((Path)reference);
        String name = ((Object)((Object)this)).getClass().getName();
        ClassLoader classLoader = ClasspathUtils.getClassLoaderForPath((Project)this.getProject(), (Path)path, (String)name);
        try {
            File classesDirFile = new File(this.classesDir);
            if (!classesDirFile.isDirectory()) {
                throw new BuildException(this.classesDir + " is not a directory.");
            }
            HashSet<String> idpAdapters = new HashSet<String>();
            HashSet<String> spAdapters = new HashSet<String>();
            HashSet<String> asAdapters = new HashSet<String>();
            HashSet<String> tokenProcessors = new HashSet<String>();
            HashSet<String> tokenGenerators = new HashSet<String>();
            HashSet<String> authenticationSelectors = new HashSet<String>();
            HashSet<String> passwordcredentialValidators = new HashSet<String>();
            HashSet<String> identityStoreProvisioners = new HashSet<String>();
            HashSet<String> dynamicClientRegistration = new HashSet<String>();
            HashSet<String> oobAuthPlugins = new HashSet<String>();
            HashSet<String> notificationProviders = new HashSet<String>();
            HashSet<String> secretManagers = new HashSet<String>();
            HashSet<String> authorizationDetailProcessors = new HashSet<String>();
            HashSet<String> captchaProviders = new HashSet<String>();
            String rootPath = classesDirFile.getPath();
            Set<String> classNames = this.getClassNames(classesDirFile, rootPath);
            for (String className : classNames) {
                Class<?> aClass = Class.forName(className, true, classLoader);
                BuildSdkDeploymentDesc.doInterfaceCheck(aClass, className, idpAdapters, spAdapters, asAdapters, tokenProcessors, tokenGenerators, authenticationSelectors, passwordcredentialValidators, identityStoreProvisioners, dynamicClientRegistration, oobAuthPlugins, notificationProviders, secretManagers, authorizationDetailProcessors, captchaProviders);
                while ((aClass = aClass.getSuperclass()) != null) {
                    BuildSdkDeploymentDesc.doInterfaceCheck(aClass, className, idpAdapters, spAdapters, asAdapters, tokenProcessors, tokenGenerators, authenticationSelectors, passwordcredentialValidators, identityStoreProvisioners, dynamicClientRegistration, oobAuthPlugins, notificationProviders, secretManagers, authorizationDetailProcessors, captchaProviders);
                }
            }
            File pfInfDir = new File(this.classesDir + File.separator + "PF-INF/");
            pfInfDir.mkdir();
            File idpFile = new File(pfInfDir, "idp-authn-adapters");
            File spFile = new File(pfInfDir, "sp-authn-adapters");
            File asFile = new File(pfInfDir, "custom-drivers");
            File tpFile = new File(pfInfDir, "token-processors");
            File tgFile = new File(pfInfDir, "token-generators");
            File adsFile = new File(pfInfDir, "authentication-selectors");
            File pcFile = new File(pfInfDir, "password-credential-validators");
            File ispFile = new File(pfInfDir, "identity-store-provisioners");
            File dcrFile = new File(pfInfDir, "dynamic-client-registration");
            File oobapFile = new File(pfInfDir, "oob-auth-plugins");
            File adpFile = new File(pfInfDir, "authorization-detail-processors");
            File npFile = new File(pfInfDir, "notification-sender");
            File smFile = new File(pfInfDir, "secret-managers");
            File cpFile = new File(pfInfDir, "captcha-providers");
            this.writeContent(idpFile, idpAdapters, IdpAuthenticationAdapter.class.getSimpleName());
            this.writeContent(spFile, spAdapters, SpAuthenticationAdapter.class.getSimpleName());
            this.writeContent(asFile, asAdapters, CustomDataSourceDriver.class.getSimpleName());
            this.writeContent(tpFile, tokenProcessors, TokenProcessor.class.getSimpleName());
            this.writeContent(tgFile, tokenGenerators, TokenGenerator.class.getSimpleName());
            this.writeContent(adsFile, authenticationSelectors, AuthenticationSelector.class.getSimpleName());
            this.writeContent(pcFile, passwordcredentialValidators, PasswordCredentialValidator.class.getSimpleName());
            this.writeContent(ispFile, identityStoreProvisioners, IdentityStoreProvisionerWithFiltering.class.getSimpleName());
            this.writeContent(dcrFile, dynamicClientRegistration, DynamicClientRegistrationPlugin.class.getSimpleName());
            this.writeContent(oobapFile, oobAuthPlugins, OOBAuthPlugin.class.getSimpleName());
            this.writeContent(adpFile, authorizationDetailProcessors, AuthorizationDetailProcessor.class.getName());
            this.writeContent(npFile, notificationProviders, NotificationPublisherPlugin.class.getSimpleName());
            this.writeContent(smFile, secretManagers, SecretManager.class.getSimpleName());
            this.writeContent(cpFile, captchaProviders, CaptchaProvider.class.getSimpleName());
            if (spAdapters.isEmpty() && idpAdapters.isEmpty() && asAdapters.isEmpty() && tokenProcessors.isEmpty() && tokenGenerators.isEmpty() && authenticationSelectors.isEmpty() && identityStoreProvisioners.isEmpty() && passwordcredentialValidators.isEmpty() && dynamicClientRegistration.isEmpty() && oobAuthPlugins.isEmpty() && notificationProviders.isEmpty() && secretManagers.isEmpty() && authorizationDetailProcessors.isEmpty() && captchaProviders.isEmpty()) {
                this.log("PF-INF plugin descriptor creation skipped. This is expected for some service plugin types.");
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static void doInterfaceCheck(Class<?> aClass, String className, Set<String> idpAdapters, Set<String> spAdapters, Set<String> asAdapters, Set<String> tokenProcessors, Set<String> tokenGenerators, Set<String> adapterSelectors, Set<String> passwordCredentialValidators, Set<String> identityStoreProvisioners, Set<String> dynamicClientRegistration, Set<String> oobAuthPlugins, Set<String> notificationProviders, Set<String> secretManagers, Set<String> authorizationDetailProcessors, Set<String> captchaProviders) {
        for (Class<?> interfaceClass : aClass.getInterfaces()) {
            if (interfaceClass.getName().equals(IdpAuthenticationAdapter.class.getName()) || interfaceClass.getName().equals(IdpAuthenticationAdapterV2.class.getName())) {
                idpAdapters.add(className);
            }
            if (interfaceClass.getName().equals(SpAuthenticationAdapter.class.getName())) {
                spAdapters.add(className);
            }
            if (interfaceClass.getName().equals(CustomDataSourceDriver.class.getName())) {
                asAdapters.add(className);
            }
            if (interfaceClass.getName().equals(TokenProcessor.class.getName())) {
                tokenProcessors.add(className);
            }
            if (interfaceClass.getName().equals(TokenGenerator.class.getName())) {
                tokenGenerators.add(className);
            }
            if (interfaceClass.getName().equals(AdapterSelector.class.getName()) || interfaceClass.getName().equals(AuthenticationSelector.class.getName())) {
                adapterSelectors.add(className);
            }
            if (interfaceClass.getName().equals(PasswordCredentialValidator.class.getName())) {
                passwordCredentialValidators.add(className);
            }
            if (interfaceClass.getName().equals(IdentityStoreProvisionerWithFiltering.class.getName())) {
                identityStoreProvisioners.add(className);
            }
            if (interfaceClass.getName().equals(DynamicClientRegistrationPlugin.class.getName())) {
                dynamicClientRegistration.add(className);
            }
            if (interfaceClass.getName().equals(OOBAuthPlugin.class.getName())) {
                oobAuthPlugins.add(className);
            }
            if (interfaceClass.getName().equals(NotificationPublisherPlugin.class.getName())) {
                notificationProviders.add(className);
            }
            if (interfaceClass.getName().equals(SecretManager.class.getName())) {
                secretManagers.add(className);
            }
            if (interfaceClass.getName().equals(AuthorizationDetailProcessor.class.getName())) {
                authorizationDetailProcessors.add(className);
            }
            if (!interfaceClass.getName().equals(CaptchaProvider.class.getName())) continue;
            captchaProviders.add(className);
        }
    }

    private void writeContent(File f, Set<String> classNames, String className) throws IOException {
        if (!classNames.isEmpty()) {
            this.log("Found " + className + "(s): " + classNames);
            this.log("Creating descriptor file: " + f);
            f.createNewFile();
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(f));){
                for (String implName : classNames) {
                    bufferedWriter.write(implName);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
            }
        }
    }

    private Set<String> getClassNames(File f, String rootPath) throws IOException {
        File[] files;
        HashSet<String> classNames = new HashSet<String>();
        if (f.isFile()) {
            String path = f.getPath();
            if (path.endsWith(DOT_CLASS)) {
                if (path.startsWith(rootPath)) {
                    path = path.substring(rootPath.length() + 1);
                }
                path = path.substring(0, path.length() - DOT_CLASS.length());
                while (path.indexOf(File.separatorChar) > -1) {
                    path = path.replace(File.separatorChar, '.');
                }
                classNames.add(path);
            }
        } else if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                classNames.addAll(this.getClassNames(file, rootPath));
            }
        }
        return classNames;
    }
}

