/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect;

import com.pingidentity.adapters.pingone.protect.CoreContract;
import com.pingidentity.adapters.pingone.protect.SessionStateSupportWrapper;
import com.pingidentity.adapters.pingone.protect.dto.RiskEvaluation;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.sdk.AuthnAdapterResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.util.log.AttributeMap;

public class AuthnAdapterResponseConverter {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(AuthnAdapterResponseConverter.class);

    public static AuthnAdapterResponse authnAdapterResponse(RiskEvaluation riskEvaluation, SessionStateSupportWrapper sessionStateSupportWrapper, String instanceId, String failureMode, String fallbackValue, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> attributeMap = AuthnAdapterResponseConverter.adapterAttributeMap(riskEvaluation, sessionStateSupportWrapper, instanceId, failureMode, fallbackValue, request, response);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAttributeMap(attributeMap);
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponseConverter.getAuthnStatus(riskEvaluation, failureMode));
        return authnAdapterResponse;
    }

    public static AttributeMap providerAttributeMap(AuthnAdapterResponse authnAdapterResponse) {
        return authnAdapterResponse.getAttributeMap().entrySet().stream().collect(AttributeMap::new, (map, entry) -> map.put((String)entry.getKey(), (String)Optional.ofNullable(entry.getValue()).map(String::valueOf).orElse(null)), AttributeMap::putAll);
    }

    private static Map<String, Object> adapterAttributeMap(RiskEvaluation riskEvaluation, SessionStateSupportWrapper sessionStateSupportWrapper, String instanceId, String failureMode, String fallbackValue, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        if (riskEvaluation != null) {
            attributeMap.put(CoreContract.RECOMMENDED_ACTION.toString(), riskEvaluation.getRecommendedAction());
            attributeMap.put(CoreContract.RISK_VALUE.toString(), riskEvaluation.getRiskValue());
            attributeMap.put(CoreContract.RISK_SCORE.toString(), riskEvaluation.getRiskScore());
            attributeMap.putAll(riskEvaluation.getApiResponseAttributes());
            sessionStateSupportWrapper.setRiskEvaluationId(instanceId, riskEvaluation.getId(), request, response);
        }
        attributeMap.put(CoreContract.RISK_LEVEL.toString(), AuthnAdapterResponseConverter.riskLevel(riskEvaluation, failureMode, fallbackValue));
        return attributeMap;
    }

    private static AuthnAdapterResponse.AUTHN_STATUS getAuthnStatus(RiskEvaluation riskEvaluation, String failureMode) {
        AuthnAdapterResponse.AUTHN_STATUS authnAdaperStatus = AuthnAdapterResponse.AUTHN_STATUS.SUCCESS;
        if (!(riskEvaluation != null && riskEvaluation.getRiskLevel() != null || "Continue with fallback policy decision".equals(failureMode))) {
            authnAdaperStatus = AuthnAdapterResponse.AUTHN_STATUS.FAILURE;
        }
        return authnAdaperStatus;
    }

    private static String riskLevel(RiskEvaluation riskEvaluation, String failureMode, String fallbackValue) {
        if (riskEvaluation != null && riskEvaluation.getRiskLevel() != null) {
            return riskEvaluation.getRiskLevel();
        }
        if ("Continue with fallback policy decision".equals(failureMode)) {
            LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.protect.log.LogEvent.USING_FALLBACK, fallbackValue);
            return fallbackValue;
        }
        LOGGER.log(com.pingidentity.adapters.pingone.protect.log.LogEvent.USING_FAILURE);
        return null;
    }
}

