/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.api;

import com.pingidentity.adapters.pingone.protect.api.ApiResponseException;
import com.pingidentity.adapters.pingone.protect.api.model.ApiErrorResponse;
import com.pingidentity.adapters.pingone.protect.api.model.ApiResponse;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.ClassicHttpResponse;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpEntity;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpException;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.ParseException;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.io.HttpClientResponseHandler;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.message.StatusLine;
import com.pingidentity.adapters.pingone.protect.util.ObjectMappers;
import java.io.IOException;

public class ApiResponseHandler<T extends ApiResponse, S extends ApiErrorResponse>
implements HttpClientResponseHandler<T> {
    private final Class<T> responseClass;
    private final Class<S> errorResponseClass;

    public ApiResponseHandler(Class<T> responseClass, Class<S> errorResponseClass) {
        this.responseClass = responseClass;
        this.errorResponseClass = errorResponseClass;
    }

    @Override
    public T handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
        StatusLine statusLine = new StatusLine(response);
        HttpEntity entity = response.getEntity();
        this.checkForHttpErrors(statusLine, entity);
        String responseBody = EntityUtils.toString(entity);
        EntityUtils.consumeQuietly(entity);
        ApiResponse t = (ApiResponse)ObjectMappers.getDefault().readValue(responseBody, this.responseClass);
        t.setJson(responseBody);
        return (T)t;
    }

    protected void checkForHttpErrors(StatusLine statusLine, HttpEntity entity) throws IOException, ParseException {
        if (statusLine.getStatusCode() >= 300) {
            String responseBody = EntityUtils.toString(entity);
            if (StringUtils.isNotBlank(responseBody)) {
                try {
                    ApiErrorResponse errorResponse = (ApiErrorResponse)ObjectMappers.getDefault().readValue(responseBody, this.errorResponseClass);
                    throw new ApiResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), errorResponse);
                }
                catch (Throwable throwable) {
                    EntityUtils.consume(entity);
                    throw throwable;
                }
            }
            EntityUtils.consume(entity);
            throw new ApiResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
    }
}

