/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.api;

import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.config.RequestConfig;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpHost;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.util.Timeout;

public class HttpClientBuilder {
    private int requestTimeout;
    private String proxySettings;
    private String proxyHost;
    private int proxyPort;
    private int maxConnectionPool;

    public HttpClientBuilder setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public HttpClientBuilder setProxySettings(String proxySettings) {
        this.proxySettings = proxySettings;
        return this;
    }

    public HttpClientBuilder setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public HttpClientBuilder setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public HttpClientBuilder setMaxConnectionPool(int maxConnectionPool) {
        this.maxConnectionPool = maxConnectionPool;
        return this;
    }

    public CloseableHttpClient build() {
        if (StringUtils.isBlank(this.proxySettings)) {
            throw new IllegalArgumentException();
        }
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds(this.requestTimeout)).setConnectTimeout(Timeout.ofMilliseconds(this.requestTimeout)).build();
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnTotal(this.maxConnectionPool).setMaxConnPerRoute(this.maxConnectionPool).build();
        com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.classic.HttpClientBuilder builder = HttpClients.custom().disableRedirectHandling().setUserAgent("PingFederate").setDefaultRequestConfig(requestConfig).setConnectionManager(connectionManager);
        CloseableHttpClient closeableHttpClient = "No Proxy".equals(this.proxySettings) ? builder.build() : ("System Defaults".equals(this.proxySettings) ? builder.useSystemProperties().build() : builder.setProxy(new HttpHost(this.proxyHost, this.proxyPort)).build());
        return closeableHttpClient;
    }
}

