/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.api;

import com.pingidentity.adapters.pingone.protect.api.ApiResponseException;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import java.io.IOException;

public class TokenServiceException
extends IOException {
    private static final long serialVersionUID = 1L;
    private static final String BASE_MESSAGE = "Request for access token for client %s failed";
    private static final String API_RESPONSE_MESSAGE = "The API responded with %d [%s - %s]";

    public TokenServiceException(String clientId, Throwable cause) {
        super(String.format(BASE_MESSAGE, clientId), cause);
    }

    private TokenServiceException(Builder builder) {
        super(builder.toString(), builder.cause);
    }

    public static class Builder {
        private String clientId;
        private int statusCode;
        private String error;
        private String errorDescription;
        private Throwable cause;

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public Builder setCause(ApiResponseException apiResponseException) {
            this.cause = apiResponseException;
            return this;
        }

        public TokenServiceException build() {
            return new TokenServiceException(this);
        }

        public String toString() {
            String message = String.format(TokenServiceException.BASE_MESSAGE, this.clientId);
            if (StringUtils.isNotBlank(this.error) && StringUtils.isNotBlank(this.errorDescription)) {
                message = message + ". " + String.format(TokenServiceException.API_RESPONSE_MESSAGE, this.statusCode, this.error, this.errorDescription);
            }
            return message;
        }
    }
}

