/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.api.model;

import com.pingidentity.adapters.pingone.protect.dto.DeviceProfile;
import com.pingidentity.adapters.pingone.protect.shade.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.pingidentity.adapters.pingone.protect.shade.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.pingidentity.adapters.pingone.protect.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.adapters.pingone.protect.shade.com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Browser {
    private String userAgent;
    private String cookie;
    private Map<String, Object> dynamicBrowserDetails;

    @JsonAnyGetter
    public Map<String, Object> getDynamicBrowserDetails() {
        return this.dynamicBrowserDetails;
    }

    @JsonIgnore
    public Object getDynamicBrowserDetail(String key) {
        return Optional.ofNullable(this.dynamicBrowserDetails).map(m -> m.get(key)).orElse(null);
    }

    @JsonAnySetter
    public void addDynamicBrowserDetails(String key, JsonNode value) {
        if (Objects.isNull(value)) {
            return;
        }
        if (Objects.isNull(this.dynamicBrowserDetails)) {
            this.dynamicBrowserDetails = new HashMap<String, Object>();
        }
        this.dynamicBrowserDetails.put(key, value);
    }

    public void setDynamicBrowserDetails(Map<String, Object> dynamicBrowserDetails) {
        this.dynamicBrowserDetails = dynamicBrowserDetails;
    }

    public Browser() {
    }

    public Browser(Builder builder) {
        this.userAgent = builder.userAgent;
        this.cookie = builder.cookie;
        this.dynamicBrowserDetails = builder.dynamicBrowserDetails;
    }

    public static Browser from(DeviceProfile deviceProfile, String browserId) {
        if (deviceProfile == null) {
            return new Builder().setCookie(browserId).build();
        }
        return new Builder().setUserAgent(deviceProfile.getUserAgent()).setDynamicBrowserDetails(deviceProfile.getFlattenedComponents()).setCookie(browserId).build();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Browser browser = (Browser)o;
        return Objects.equals(this.userAgent, browser.userAgent) && Objects.equals(this.dynamicBrowserDetails, browser.dynamicBrowserDetails) && Objects.equals(this.cookie, browser.cookie);
    }

    public int hashCode() {
        return Objects.hash(this.userAgent, this.dynamicBrowserDetails, this.cookie);
    }

    public static class Builder {
        private String userAgent;
        private String cookie;
        private Map<String, Object> dynamicBrowserDetails;

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setDynamicBrowserDetails(Map<String, Object> dynamicBrowserDetails) {
            this.dynamicBrowserDetails = dynamicBrowserDetails;
            return this;
        }

        public Builder setCookie(String cookie) {
            this.cookie = cookie;
            return this;
        }

        public Browser build() {
            return new Browser(this);
        }
    }
}

