/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.configuration.adapter;

import com.pingidentity.adapters.pingone.protect.api.model.Result;
import com.pingidentity.adapters.pingone.protect.configuration.adapter.action.TestConnectionAction;
import com.pingidentity.adapters.pingone.protect.dto.OptionalUserAttribute;
import com.pingidentity.adapters.pingone.protect.dto.RiskPolicyPreRenderCallback;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.util.JsonPointerValidator;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.protect.validator.AdapterDeviceTrustConfigurationValidator;
import com.pingidentity.adapters.pingone.protect.validator.AdapterEnvironmentConfigurationValidator;
import com.pingidentity.adapters.pingone.protect.validator.ApiResponseMappingTableValidator;
import com.pingidentity.adapters.pingone.protect.validator.FallbackConfigurationValidator;
import com.pingidentity.adapters.pingone.protect.validator.OptionalUserAttributesValidator;
import com.pingidentity.adapters.pingone.protect.validator.PredictorAttributeMappingValidator;
import com.pingidentity.adapters.pingone.protect.validator.ProxyConfigurationValidator;
import com.pingidentity.adapters.pingone.protect.validator.TableUniqueKeyValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class PingOneProtectAdapterConfiguration {
    private static final OptionalUserAttributesTable OPTIONAL_USER_ATTRIBUTES_TABLE = new OptionalUserAttributesTable();
    private static final OptionalPredictorsTable OPTIONAL_PREDICTORS_TABLE = new OptionalPredictorsTable();
    private static final ApiResponseMappingsTable API_RESPONSE_MAPPINGS_TABLE = new ApiResponseMappingsTable();
    private static final IncludeDynamicDeviceProfileField INCLUDE_DYNAMIC_DEVICE_PROFILE_FIELD = new IncludeDynamicDeviceProfileField();
    private static final DeviceProfilingTimeoutField DEVICE_PROFILING_TIMEOUT_FIELD = new DeviceProfilingTimeoutField();
    private static final DeviceProfileCookieNameField COOKIE_NAME_FIELD = new DeviceProfileCookieNameField();
    private static final FailureModeField FAILURE_MODE_FIELD = new FailureModeField();
    private static final FallbackValueField FALLBACK_VALUE_FIELD = new FallbackValueField();
    private static final RequestTimeoutField REQUEST_TIMEOUT_FIELD = new RequestTimeoutField();
    private static final ProxySettingsField PROXY_SETTINGS_RADIO_GROUP_FIELD = new ProxySettingsField();
    private static final ProxyHostField PROXY_HOST_FIELD = new ProxyHostField();
    private static final ProxyPortField PROXY_PORT_FIELD = new ProxyPortField();
    private static final MaxConnectionPoolField MAX_CONNECTION_POOL_FIELD = new MaxConnectionPoolField();
    private static final EnablePingIdDeviceTrustPayload ENABLE_PINGID_DEVICE_TRUST_PAYLOAD = new EnablePingIdDeviceTrustPayload();
    private static final PingIdAgentPortField PINGID_AGENT_PORT_FIELD = new PingIdAgentPortField();
    private static final PingIdAgentTimeoutField PINGID_AGENT_TIMEOUT_FIELD = new PingIdAgentTimeoutField();
    private static final TestConnectionActionDescriptor TEST_CONNECTION_ACTION_DESCRIPTOR = new TestConnectionActionDescriptor();

    public static AdapterConfigurationGuiDescriptor makeAdapterConfigurationGuiDescriptor() {
        return PingOneProtectAdapterConfiguration.makeAdapterConfigurationGuiDescriptor(null);
    }

    public static AdapterConfigurationGuiDescriptor makeAdapterConfigurationGuiDescriptor(Configuration configuration) {
        AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor = new AdapterConfigurationGuiDescriptor();
        adapterConfigurationGuiDescriptor.setDescription("The PingOne Protect Adapter sends device profile and transaction information to PingOne Protect. PingOne Protect evaluates the security risk and returns a risk level for the transaction. This allows PingFederate to make intelligent policy decisions based on risk level.");
        adapterConfigurationGuiDescriptor.addTable((TableDescriptor)OPTIONAL_USER_ATTRIBUTES_TABLE);
        adapterConfigurationGuiDescriptor.addTable((TableDescriptor)OPTIONAL_PREDICTORS_TABLE);
        adapterConfigurationGuiDescriptor.addTable((TableDescriptor)API_RESPONSE_MAPPINGS_TABLE);
        adapterConfigurationGuiDescriptor.addField(PingOneEnvironmentField.newPingOneEnvironmentField());
        if (configuration == null || PingOneEnvironmentField.isConfigured(configuration)) {
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)new PingOneRiskPolicyField(configuration));
            adapterConfigurationGuiDescriptor.addPreRenderCallback((PreRenderCallback)new RiskPolicyPreRenderCallback());
        }
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)INCLUDE_DYNAMIC_DEVICE_PROFILE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)DEVICE_PROFILING_TIMEOUT_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)COOKIE_NAME_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)FAILURE_MODE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)FALLBACK_VALUE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)REQUEST_TIMEOUT_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_SETTINGS_RADIO_GROUP_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_HOST_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_PORT_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)MAX_CONNECTION_POOL_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)ENABLE_PINGID_DEVICE_TRUST_PAYLOAD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PINGID_AGENT_PORT_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PINGID_AGENT_TIMEOUT_FIELD);
        adapterConfigurationGuiDescriptor.addValidator((ConfigurationValidator)new ProxyConfigurationValidator());
        adapterConfigurationGuiDescriptor.addValidator((ConfigurationValidator)new FallbackConfigurationValidator());
        adapterConfigurationGuiDescriptor.addValidator((ConfigurationValidator)new AdapterEnvironmentConfigurationValidator());
        adapterConfigurationGuiDescriptor.addValidator((ConfigurationValidator)new AdapterDeviceTrustConfigurationValidator());
        adapterConfigurationGuiDescriptor.addAction((ActionDescriptor)TEST_CONNECTION_ACTION_DESCRIPTOR);
        return adapterConfigurationGuiDescriptor;
    }

    public static boolean containsField(AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor, String fieldName) {
        return adapterConfigurationGuiDescriptor.getFields().stream().anyMatch(descriptor -> fieldName.equals(descriptor.getName()));
    }

    public static class PingIdAgentPortField
    extends TextFieldDescriptor {
        private PingIdAgentPortField() {
            super("PingID Device Trust Agent Port", "The port number to use when connecting to the PingID Device Trust Agent. If left blank, the default port 9400 will be used.");
            this.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        }

        public static Integer getPingIdAgentPort(Configuration configuration) {
            return configuration.getIntFieldValue("PingID Device Trust Agent Port");
        }
    }

    public static class PingIdAgentTimeoutField
    extends TextFieldDescriptor {
        private PingIdAgentTimeoutField() {
            super("PingID Device Trust Agent Timeout", "The time, in milliseconds, that PingFederate allows for establishing a connection with the PingID Device Trust Agent. If left blank, the default value is set by the Protect SDK. If specified, the value must be between 200 and 10,000 milliseconds.");
            this.addValidator((FieldValidator)new IntegerValidator(200, 10000), true);
        }

        public static Integer getPingIdAgentTimeout(Configuration configuration) {
            return configuration.getIntFieldValue("PingID Device Trust Agent Timeout");
        }
    }

    public static class EnablePingIdDeviceTrustPayload
    extends CheckBoxFieldDescriptor {
        public EnablePingIdDeviceTrustPayload() {
            super("Collect PingID Device Trust Attributes", "When enabled, the Protect SDK collects attributes from the PingID Device Trust Agent and sends them to PingOne Protect.");
            this.setDefaultValue(false);
        }

        public static boolean isPingIdDeviceTrustPayloadEnabled(Configuration configuration) {
            return Optional.ofNullable(configuration).map(conf -> conf.getBooleanFieldValue("Collect PingID Device Trust Attributes")).orElse(false);
        }
    }

    public static class TestConnectionActionDescriptor
    extends ActionDescriptor {
        private TestConnectionActionDescriptor() {
            super("Test PingOne Protect connection", "Perform a test connection to PingOne Protect to validate your configuration.", (ActionDescriptor.Action)new TestConnectionAction());
        }
    }

    public static class MaxConnectionPoolField
    extends TextFieldDescriptor {
        private MaxConnectionPoolField() {
            super("Custom connection pool", "The number of connections to PingOne Protect should range from a minimum of 25 to a maximum limit of 200.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator(25, 200));
            this.setDefaultValue("50");
        }

        public static int getMaxConnectionPool(Configuration configuration) {
            return configuration.getIntFieldValue("Custom connection pool");
        }
    }

    public static class ProxyPortField
    extends TextFieldDescriptor {
        private ProxyPortField() {
            super("Custom Proxy Port", "The proxy server port to use when 'Proxy Settings' is set to 'Custom'.");
            this.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        }

        public static int getProxyPort(Configuration configuration) {
            return configuration.getIntFieldValue("Custom Proxy Port");
        }
    }

    public static class ProxyHostField
    extends TextFieldDescriptor {
        private ProxyHostField() {
            super("Custom Proxy Host", "The proxy server hostname to use when 'Proxy Settings' is set to 'Custom'.");
        }

        public static String getProxyHost(Configuration configuration) {
            return configuration.getFieldValue("Custom Proxy Host");
        }
    }

    public static class ProxySettingsField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"No Proxy", "System Defaults", "Custom"};

        private ProxySettingsField() {
            super("Proxy Settings", "Defines proxy settings for outbound HTTP requests.", OPTION_VALUES);
            this.setDefaultValue("System Defaults");
        }

        public static String getProxySettings(Configuration configuration) {
            return configuration.getFieldValue("Proxy Settings");
        }
    }

    public static class RequestTimeoutField
    extends TextFieldDescriptor {
        private RequestTimeoutField() {
            super("API Request Timeout", "The amount of time in milliseconds that PingFederate allows when establishing a connection with PingOne or waiting for a response to a request. The default value is '2000'. A value of 0 disables the timeout.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator(0, Integer.MAX_VALUE));
            this.setDefaultValue("2000");
        }

        public static int getRequestTimeout(Configuration configuration) {
            return configuration.getIntFieldValue("API Request Timeout");
        }
    }

    public static class FallbackValueField
    extends TextFieldDescriptor {
        private FallbackValueField() {
            super("Fallback Policy Decision Value", "The risk result (for example, \"LOW\", \"MEDIUM\", \"HIGH\", or \"unknown\") to use in the authentication policy when the PingOne Protect service is unavailable or an error occurs, and 'Failure Mode' is set to 'Continue with fallback policy decision'.");
            this.setDefaultValue(Result.Level.MEDIUM.toString());
        }

        public static String getFallbackValue(Configuration configuration) {
            return configuration.getFieldValue("Fallback Policy Decision Value");
        }
    }

    public static class FailureModeField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"Continue with fallback policy decision", "Fail"};

        private FailureModeField() {
            super("Failure Mode", "When PingOne Protect is unavailable or an error occurs, this setting determines whether the user's sign-on attempt should fail or continue with a pre-determined policy decision.", OPTION_VALUES);
            this.setDefaultValue("Continue with fallback policy decision");
        }

        public static String getFailureMode(Configuration configuration) {
            return configuration.getFieldValue("Failure Mode");
        }
    }

    public static class DeviceProfileCookieNameField
    extends TextFieldDescriptor {
        private DeviceProfileCookieNameField() {
            super("Device Profile Cookie Name", "The name of the cookie that indicates whether the device profile has been captured.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.setDefaultValue("pingone.protect.device.profile");
        }

        public static String getDeviceProfileCookieName(Configuration configuration) {
            return configuration.getFieldValue("Device Profile Cookie Name");
        }
    }

    public static class DeviceProfilingTimeoutField
    extends TextFieldDescriptor {
        private DeviceProfilingTimeoutField() {
            super("Device Profiling Timeout", "The amount of time in milliseconds that PingFederate waits for the device profiling script to collect device details. Applies only if 'Device Profiling Method' is 'Captured by this adapter'.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator(0, Integer.MAX_VALUE));
            this.setDefaultValue("5000");
        }

        public static int getDeviceProfilingTimeout(Configuration configuration) {
            return configuration.getIntFieldValue("Device Profiling Timeout");
        }
    }

    public static class IncludeDynamicDeviceProfileField
    extends CheckBoxFieldDescriptor {
        public IncludeDynamicDeviceProfileField() {
            super("Include Dynamic Device Profile", "When enabled, PingFederate will include a device profile in the risk evaluation.");
            this.setDefaultValue(true);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static boolean isIncludeDynamicDeviceProfile(Configuration configuration) {
            return configuration.getBooleanFieldValue("Include Dynamic Device Profile");
        }
    }

    public static class PingOneRiskPolicyField
    extends SelectFieldDescriptor {
        public PingOneRiskPolicyField(Configuration configuration) {
            super("PingOne Risk Policy", "The risk policy used by PingOne for the risk evaluation. Overrides the environment and global default policy selections. This list is populated when you select a PingOne Environment.");
            String defaultValue = PingOneRiskPolicyField.getRiskPolicyId(configuration);
            this.setDefaultValue(defaultValue);
            this.setDefaultForLegacyConfig(defaultValue);
        }

        public static String getRiskPolicyId(Configuration configuration) {
            String value = configuration == null ? null : configuration.getFieldValue("PingOne Risk Policy");
            return value;
        }
    }

    public static class PingOneEnvironmentField {
        public static FieldDescriptor newPingOneEnvironmentField() {
            try {
                Class<?> pingOneEnvironmentFieldClass = Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
                Constructor<?> pingOneEnvironmentFieldConstructor = pingOneEnvironmentFieldClass.getConstructor(String.class, String.class);
                return (FieldDescriptor)pingOneEnvironmentFieldConstructor.newInstance("PingOne Environment", "Your PingOne environment. Create connections in System > External Systems > PingOne Connections.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String getPingOneEnvironment(Configuration configuration) {
            return Optional.ofNullable(configuration).map(conf -> conf.getFieldValue("PingOne Environment")).orElse(null);
        }

        public static boolean isConfigured(Configuration configuration) {
            return StringUtils.isNotEmpty(PingOneEnvironmentField.getPingOneEnvironment(configuration));
        }
    }

    public static class ApiResponseMappingsTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new LocalAttributeField(), new ApiAttributeMappingField()});

        public ApiResponseMappingsTable() {
            super("PingOne Protect API Response Mappings (optional)", "Define local attributes to include in the attribute contract, and map them to a value from the PingOne Protect response payload using JSON Pointer (RFC 6901) syntax. Click 'Add a new row ...' to add multiple entries.", ROW);
            this.addValidator((RowValidator)new ApiResponseMappingTableValidator());
        }

        public static Map<String, String> getApiResponseMappings(Configuration configuration) {
            return Optional.ofNullable(configuration.getTable("PingOne Protect API Response Mappings (optional)")).map(Table::getRows).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(row -> row.getFieldValue("Local Attribute"), row -> row.getFieldValue("PingOne Protect API Attribute Mapping")));
        }
    }

    public static class ApiAttributeMappingField
    extends TextFieldDescriptor {
        private ApiAttributeMappingField() {
            super("PingOne Protect API Attribute Mapping", null);
            this.addValidator(new JsonPointerValidator());
        }
    }

    public static class LocalAttributeField
    extends TextFieldDescriptor {
        private LocalAttributeField() {
            super("Local Attribute", null);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }
    }

    public static class OptionalPredictorsTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new LocalPredictorAttributeField(), new RiskPredictorNameField()});

        private OptionalPredictorsTable() {
            super("Additional Risk Predictors (optional)", "Optionally, you can send risk predictors to PingOne Protect for evaluation. To populate these PingOne Risk Predictors, map them to attributes that are passed to this adapter instance from any source that appears earlier in your PingFederate authentication policy. ", ROW);
            this.addValidator((RowValidator)new TableUniqueKeyValidator("Additional Risk Predictors (optional)", "Incoming Attribute Name"));
            this.addValidator((RowValidator)new TableUniqueKeyValidator("Additional Risk Predictors (optional)", "PingOne Protect Attribute"));
            this.addValidator((RowValidator)new PredictorAttributeMappingValidator("Additional Risk Predictors (optional)", "PingOne Protect Attribute"));
        }

        public static Map<String, String> getOptionalPredictorsMapping(Configuration configuration) {
            if (null != configuration.getTable("Additional Risk Predictors (optional)")) {
                return configuration.getTable("Additional Risk Predictors (optional)").getRows().stream().collect(Collectors.toMap(row -> row.getFieldValue("Incoming Attribute Name"), row -> row.getFieldValue("PingOne Protect Attribute")));
            }
            return Collections.emptyMap();
        }
    }

    public static class RiskPredictorNameField
    extends TextFieldDescriptor {
        private RiskPredictorNameField() {
            super("PingOne Protect Attribute", "The PingOne Protect attribute that will be assessed in the risk policy, such as ${event.isManaged}. ");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }
    }

    public static class LocalPredictorAttributeField
    extends TextFieldDescriptor {
        private LocalPredictorAttributeField() {
            super("Incoming Attribute Name", "The PingFederate authentication policy attribute used to populate the PingOne Protect attribute.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }
    }

    public static class OptionalUserAttributesTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new IncomingAttributeNameField(), new UserAttributeField()});

        private OptionalUserAttributesTable() {
            super("Additional User Attributes (optional)", "Optionally, you can send additional attributes to PingOne Protect for verification. To populate these parameters, map them to attributes that are passed to this adapter instance from any source that appears earlier in your PingFederate authentication policy.", ROW);
            this.addValidator((RowValidator)new OptionalUserAttributesValidator());
        }

        public static Map<String, OptionalUserAttribute> getOptionalUserAttributesMapping(Configuration configuration) {
            return Optional.ofNullable(configuration.getTable("Additional User Attributes (optional)")).map(Table::getRows).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).filter(row -> Optional.ofNullable(row.getFieldValue("Incoming Attribute Name")).isPresent() && Optional.ofNullable(row.getFieldValue("PingOne Protect Management Attribute")).isPresent()).collect(Collectors.toMap(row -> row.getFieldValue("Incoming Attribute Name"), row -> OptionalUserAttribute.fromValue(row.getFieldValue("PingOne Protect Management Attribute"))));
        }
    }

    public static class UserAttributeField
    extends SelectFieldDescriptor {
        private static final List<AbstractSelectionFieldDescriptor.OptionValue> OPTION_VALUES = Arrays.asList(new AbstractSelectionFieldDescriptor.OptionValue(SelectFieldDescriptor.SELECT_ONE.getName(), SelectFieldDescriptor.SELECT_ONE.getValue()), new AbstractSelectionFieldDescriptor.OptionValue(OptionalUserAttribute.USER_GROUPS.getName(), OptionalUserAttribute.USER_GROUPS.getValue()));

        private UserAttributeField() {
            super("PingOne Protect Management Attribute", null, OPTION_VALUES);
            this.setLabel("PingOne Protect Attribute");
        }
    }

    public static class IncomingAttributeNameField
    extends TextFieldDescriptor {
        private IncomingAttributeNameField() {
            super("Incoming Attribute Name", null);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }
    }
}

