/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.dto;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapper;
import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapperFactory;
import com.pingidentity.adapters.pingone.protect.api.RiskServiceException;
import com.pingidentity.adapters.pingone.protect.api.TokenServiceException;
import com.pingidentity.adapters.pingone.protect.configuration.adapter.PingOneProtectAdapterConfiguration;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskService;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskServiceFactory;
import com.pingidentity.adapters.pingone.protect.log.LogEvent;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;

public class RiskPolicyPreRenderCallback
implements PreRenderCallback {
    private final RiskServiceFactory riskServiceFactory;
    private final PingOneEnvironmentAccessorWrapperFactory pingOneEnvironmentAccessorWrapperFactory = new PingOneEnvironmentAccessorWrapperFactory();
    private static final IntegrationsLogger LOG = new IntegrationsLogger(RiskPolicyPreRenderCallback.class);
    private static final String CACHE_KEY_PREFIX = "riskPolicy.";
    private static final Cache<String, List<AbstractSelectionFieldDescriptor.OptionValue>> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public void callback(List<FieldDescriptor> fields, List<FieldDescriptor> advancedFields, List<TableDescriptor> tables, Configuration configuration) {
        if (PingOneProtectAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration) && this.isValidPingOneEnvironment(configuration)) {
            List<AbstractSelectionFieldDescriptor.OptionValue> optionValues = this.getRiskPolicyOptionValues(configuration);
            Optional<FieldDescriptor> populationField = this.getRiskPolicyField(fields);
            populationField.ifPresent(fieldDescriptor -> ((SelectFieldDescriptor)fieldDescriptor).setOptionValues(optionValues));
        }
    }

    private Optional<FieldDescriptor> getRiskPolicyField(List<FieldDescriptor> fields) {
        return fields.stream().filter(descriptor -> "PingOne Risk Policy".equals(descriptor.getName())).findFirst();
    }

    private boolean isValidPingOneEnvironment(Configuration configuration) {
        try {
            Class<?> pingOneEnvironmentValidatorClass = Class.forName("org.sourceid.saml20.adapter.gui.validation.impl.PingOneEnvironmentValidator");
            Constructor<?> pingOneEnvironmentValidatorConstructor = pingOneEnvironmentValidatorClass.getConstructor(new Class[0]);
            Object pingOneEnvironmentValidator = pingOneEnvironmentValidatorConstructor.newInstance(new Object[0]);
            Method validateMethod = pingOneEnvironmentValidatorClass.getMethod("validate", Field.class);
            validateMethod.invoke(pingOneEnvironmentValidator, configuration.getField("PingOne Environment"));
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    public RiskPolicyPreRenderCallback() {
        this.riskServiceFactory = new RiskServiceFactory();
    }

    private List<AbstractSelectionFieldDescriptor.OptionValue> getRiskPolicyOptionValues(Configuration configuration) {
        String pingOneEnvironment = PingOneProtectAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
        String cacheKey = CACHE_KEY_PREFIX + pingOneEnvironment;
        List<Object> optionValues = (List)cache.getIfPresent((Object)cacheKey);
        if (optionValues == null) {
            PingOneEnvironmentAccessorWrapper pingOneEnvironmentAccessorWrapper = this.pingOneEnvironmentAccessorWrapperFactory.create(configuration);
            RiskService riskService = this.riskServiceFactory.create(configuration, pingOneEnvironmentAccessorWrapper);
            try {
                LOG.log(LogEvent.GET_RISK_POLICY);
                Map<String, String> riskPolicySetNames = riskService.getRiskPolicyNamesById();
                optionValues = this.asOptionValues(riskPolicySetNames);
                cache.put((Object)cacheKey, optionValues);
            }
            catch (RiskServiceException | TokenServiceException e) {
                LOG.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.GET_RISK_POLICY_ERROR, e);
                optionValues = Collections.emptyList();
            }
        }
        return optionValues;
    }

    private List<AbstractSelectionFieldDescriptor.OptionValue> asOptionValues(Map<String, String> riskPolicySetNames) {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        optionValues.addAll(riskPolicySetNames.entrySet().stream().map(entry -> new AbstractSelectionFieldDescriptor.OptionValue((String)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList()));
        return optionValues;
    }
}

