/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.evaluation;

import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.BooleanUtils;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.locale.LocaleUtil;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;

public class PingOneProtectManagementAdapterTemplateSupport {
    public boolean isSubmitDeviceProfileRequest(HttpServletRequest request) {
        return request.getParameter("pingone.protect.device.profile") != null;
    }

    public void renderDeviceProfileTemplate(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters, Map<String, Object> customInParams) throws AuthnAdapterException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LanguagePackMessages languagePackMessages = new LanguagePackMessages("pingone-protect-messages", LocaleUtil.getUserLocale((HttpServletRequest)request));
        params.put("languagePackMessages", languagePackMessages);
        params.put("action", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("deviceProfilingTimeout", customInParams.get("deviceProfilingTimeout"));
        params.put("submitDeviceProfile", "pingone.protect.device.profile");
        this.appendPingIdDeviceTrustAttrParams(params, customInParams);
        try {
            TemplateRendererUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (String)"pingone-protect-template.html", params);
        }
        catch (TemplateRendererUtilException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    private void appendPingIdDeviceTrustAttrParams(Map<String, Object> params, Map<String, Object> customInParams) {
        Boolean enablePingIdDeviceTrustPayload = (Boolean)Optional.ofNullable(customInParams).map(map -> map.get("collectDeviceTrustAttributes")).orElse(false);
        if (BooleanUtils.isFalse(enablePingIdDeviceTrustPayload)) {
            return;
        }
        params.put("collectDeviceTrustAttributes", customInParams.get("collectDeviceTrustAttributes"));
        Integer deviceTrustPort = (Integer)customInParams.get("deviceTrustAgentPort");
        Integer deviceTrustTimeout = (Integer)customInParams.get("deviceTrustAgentTimeout");
        if (deviceTrustPort != null && deviceTrustPort != 0) {
            params.put("deviceTrustAgentPort", deviceTrustPort);
        }
        if (deviceTrustTimeout != null && deviceTrustTimeout != 0) {
            params.put("deviceTrustAgentTimeout", deviceTrustTimeout);
        }
    }
}

