/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.evaluation;

import com.pingidentity.adapters.pingone.protect.api.ApiResponseMapper;
import com.pingidentity.adapters.pingone.protect.api.model.Browser;
import com.pingidentity.adapters.pingone.protect.api.model.Event;
import com.pingidentity.adapters.pingone.protect.api.model.Flow;
import com.pingidentity.adapters.pingone.protect.api.model.Group;
import com.pingidentity.adapters.pingone.protect.api.model.Hash;
import com.pingidentity.adapters.pingone.protect.api.model.Password;
import com.pingidentity.adapters.pingone.protect.api.model.Result;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEvaluationRequest;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEvaluationResponse;
import com.pingidentity.adapters.pingone.protect.api.model.SDK;
import com.pingidentity.adapters.pingone.protect.api.model.Session;
import com.pingidentity.adapters.pingone.protect.api.model.Signals;
import com.pingidentity.adapters.pingone.protect.api.model.TargetResource;
import com.pingidentity.adapters.pingone.protect.api.model.User;
import com.pingidentity.adapters.pingone.protect.dto.CompletionStatus;
import com.pingidentity.adapters.pingone.protect.dto.OptionalUserAttribute;
import com.pingidentity.adapters.pingone.protect.dto.RiskEvaluation;
import com.pingidentity.adapters.pingone.protect.dto.RiskEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class RiskEvaluationTranslator {
    private RiskEvaluationTranslator() {
    }

    public static RiskEvaluationRequest translateToRequest(RiskEvent riskEvent) {
        Event event = new Event.Builder().setIp(riskEvent.getIpAddress()).setUser(new User(User.Type.EXTERNAL.name(), riskEvent.getUsername(), Optional.ofNullable(riskEvent.getPassword()).map(pass -> new Password(new Hash(pass.getHash().getAlgorithm(), pass.getHash().getValue()))).orElse(null), RiskEvaluationTranslator.getUserGroups(riskEvent))).setBrowser(Browser.from(riskEvent.getDeviceProfile(), riskEvent.getBrowserId())).setTargetResource(new TargetResource(riskEvent.getTargetResourceId(), riskEvent.getTargetResourceName())).setFlow(RiskEvaluationTranslator.getFlow(riskEvent)).setSession(new Session(riskEvent.getTrackingId())).setCompletionStatus(CompletionStatus.IN_PROGRESS.name()).setSharingType(riskEvent.getSharingType()).setOrigin(riskEvent.getOrigin()).setPredictorDetails(RiskEvaluationTranslator.getPredictors(riskEvent)).setSdk(Optional.ofNullable(riskEvent.getSdk()).map(sdk -> new SDK(new Signals(sdk.getSignals().getData()))).orElse(null)).build();
        return new RiskEvaluationRequest(event);
    }

    public static RiskEvaluation translateFromResponse(RiskEvaluationResponse riskEvaluationResponse, Map<String, String> apiResponseMappings) {
        String id = riskEvaluationResponse.getId();
        Result result = riskEvaluationResponse.getResult();
        String recommendedAction = null;
        String riskLevel = null;
        String riskValue = null;
        Double riskScore = null;
        if (result != null) {
            recommendedAction = result.getRecommendedAction();
            riskLevel = result.getLevel().name();
            riskValue = result.getValue();
            riskScore = result.getScore();
        }
        String json = riskEvaluationResponse.getJson();
        Map<String, Object> apiResponseAttributes = ApiResponseMapper.map(apiResponseMappings, json);
        return new RiskEvaluation(id, recommendedAction, riskLevel, riskValue, riskScore, apiResponseAttributes);
    }

    private static List<Group> getUserGroups(RiskEvent riskEvent) {
        Map optionalUserAttributes = Optional.ofNullable(riskEvent.getOptionalUserAttributes()).orElse(Collections.emptyMap());
        if (!optionalUserAttributes.isEmpty() && optionalUserAttributes.containsKey((Object)OptionalUserAttribute.USER_GROUPS)) {
            return riskEvent.getOptionalUserAttributes().get((Object)OptionalUserAttribute.USER_GROUPS).getValuesAsCollection().stream().map(Group::new).collect(Collectors.toList());
        }
        return null;
    }

    private static Map<String, Object> getPredictors(RiskEvent riskEvent) {
        Map<String, AttributeValue> optionalRiskPredictors = riskEvent.getOptionalRiskPredictors();
        if (null != optionalRiskPredictors && !optionalRiskPredictors.isEmpty()) {
            return optionalRiskPredictors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AttributeValue)e.getValue()).getObjectValue()));
        }
        return null;
    }

    private static Flow getFlow(RiskEvent riskEvent) {
        if (Objects.nonNull(riskEvent.getFlow())) {
            return new Flow(riskEvent.getFlow().getType(), riskEvent.getFlow().getSubtype());
        }
        return new Flow();
    }
}

