/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.evaluation;

import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapper;
import com.pingidentity.adapters.pingone.protect.api.HttpClientBuilder;
import com.pingidentity.adapters.pingone.protect.api.RiskApiClient;
import com.pingidentity.adapters.pingone.protect.api.TokenProviderException;
import com.pingidentity.adapters.pingone.protect.api.TokenService;
import com.pingidentity.adapters.pingone.protect.configuration.adapter.PingOneProtectAdapterConfiguration;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskService;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskServiceImpl;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent.Executor;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import java.util.Map;
import org.sourceid.saml20.adapter.conf.Configuration;

public class RiskServiceFactory {
    public RiskService create(Configuration configuration, PingOneEnvironmentAccessorWrapper pingOneEnvironmentAccessorWrapper) {
        if (!PingOneProtectAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
            throw new IllegalArgumentException("PingOne Environment is not configured");
        }
        Map<String, String> apiResponseMappings = PingOneProtectAdapterConfiguration.ApiResponseMappingsTable.getApiResponseMappings(configuration);
        String pingOneEnvironment = PingOneProtectAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
        String envId = pingOneEnvironmentAccessorWrapper.getEnvironmentId();
        String riskPolicySetId = PingOneProtectAdapterConfiguration.PingOneRiskPolicyField.getRiskPolicyId(configuration);
        String apiEndpoint = pingOneEnvironmentAccessorWrapper.getManagementEndpoint();
        int requestTimeout = PingOneProtectAdapterConfiguration.RequestTimeoutField.getRequestTimeout(configuration);
        String proxySettings = PingOneProtectAdapterConfiguration.ProxySettingsField.getProxySettings(configuration);
        String proxyHost = PingOneProtectAdapterConfiguration.ProxyHostField.getProxyHost(configuration);
        int proxyPort = PingOneProtectAdapterConfiguration.ProxyPortField.getProxyPort(configuration);
        int maxConnectionPool = PingOneProtectAdapterConfiguration.MaxConnectionPoolField.getMaxConnectionPool(configuration);
        CloseableHttpClient httpClient = new HttpClientBuilder().setRequestTimeout(requestTimeout).setProxySettings(proxySettings).setProxyHost(proxyHost).setProxyPort(proxyPort).setMaxConnectionPool(maxConnectionPool).build();
        Executor executor = Executor.newInstance(httpClient);
        TokenService tokenService = new TokenService(() -> {
            try {
                return pingOneEnvironmentAccessorWrapper.getAccessToken();
            }
            catch (Throwable e) {
                throw new TokenProviderException("Error requesting access token", e);
            }
        }, pingOneEnvironment);
        RiskApiClient riskApiClient = new RiskApiClient(executor, apiEndpoint, envId);
        return new RiskServiceImpl(tokenService, riskApiClient, apiResponseMappings, riskPolicySetId);
    }
}

