/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent;

import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.ClientProtocolException;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.HttpResponseException;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent.Content;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent.ContentResponseHandler;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.ClassicHttpResponse;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpEntity;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpException;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpResponse;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.io.HttpClientResponseHandler;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.io.entity.EntityUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Response {
    private final ClassicHttpResponse response;
    private boolean consumed;

    Response(ClassicHttpResponse response) {
        this.response = response;
    }

    private void assertNotConsumed() {
        if (this.consumed) {
            throw new IllegalStateException("Response content has been already consumed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        if (this.consumed) {
            return;
        }
        try {
            InputStream content;
            HttpEntity entity = this.response.getEntity();
            if (entity != null && (content = entity.getContent()) != null) {
                content.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.consumed = true;
        }
    }

    public void discardContent() {
        this.dispose();
    }

    public <T> T handleResponse(HttpClientResponseHandler<T> handler) throws IOException {
        this.assertNotConsumed();
        try {
            T t = handler.handleResponse(this.response);
            return t;
        }
        catch (HttpException ex) {
            throw new ClientProtocolException(ex);
        }
        finally {
            this.dispose();
        }
    }

    public Content returnContent() throws IOException {
        return this.handleResponse(new ContentResponseHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse returnResponse() throws IOException {
        this.assertNotConsumed();
        try {
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(EntityUtils.toByteArray(entity), ContentType.parse(entity.getContentType()));
                this.response.setEntity(byteArrayEntity);
            }
            ClassicHttpResponse classicHttpResponse = this.response;
            return classicHttpResponse;
        }
        finally {
            this.consumed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContent(File file) throws IOException {
        this.assertNotConsumed();
        int status = this.response.getCode();
        if (status >= 300) {
            throw new HttpResponseException(status, this.response.getReasonPhrase());
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                entity.writeTo(out);
            }
        }
        finally {
            this.consumed = true;
        }
    }
}

