/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.Utils;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.FileHandlingException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.common.upgrade.exception.UnsupportedUpgradeVersionException;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.hsm.BCFIPSStarter;
import com.pingidentity.pingcommons.upgrade.zip.UnzipUtil;
import com.pingidentity.pingfederate.migration.PingFederateMigrator;
import com.pingidentity.pingfederate.migration.exception.UpgradeException;
import com.pingidentity.pingfederate.migration.exception.UpgradeUtilityException;
import com.pingidentity.pingfederate.migration.prompts.ReleaseNotePrompt;
import com.pingidentity.pingfederate.migration.prompts.UpgradeConsiderationPrompt;
import com.pingidentity.pingfederate.migration.util.LoggingUtilLog4j;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pingidentity.utils.LoggingUtil;
import org.pingidentity.validate.AdminApiAuthPropertyValidator;

public class UpgradeUtility {
    public static final String UPGRADE_COMPLETE_FILE = "upgrade_status.txt";
    public static final String UPGRADE_LOG = "upgrade.log";
    private static final Logger log = LogManager.getLogger(UpgradeUtility.class);
    public static final String ARGUMENT_ID_SOURCE_PF_DIR = "<sourcePingfederateRootDir>";
    public static final String ARGUMENT_ID_DESTINATION_PF_DIR = "<destinationPingfederateRootDir>";
    public static final String ARGUMENT_ID_CUSTOM = "-c";
    public static final String ARGUMENT_ID_LICENSE = "-l";
    public static final String ARGUMENT_ID_LICENSE_PATH = "<newPingFederateLicense>";
    public static final String ARGUMENT_ID_RELEASE_NOTES_REVIEWED = "--release-notes-reviewed";
    public static final String ARGUMENT_DESCRIPTION_SOURCE_PF_DIR = "The full or relative path of the base directory where the existing PingFederate software (pingfederate/*) is installed";
    public static final String ARGUMENT_DESCRIPTION_CUSTOM = "Run the utility in custom mode, allowing administrators to override several default migration steps";
    public static final String ARGUMENT_DESCRIPTION_LICENSE = "Optional path and filename of the license to use for the upgraded PingFederate version";
    public static final String ARGUMENT_DESCRIPTION_RELEASE_NOTES_REVIEWED = "Optional flag indicating that the release notes have been reviewed";
    public static final String SYNTAX = "<sourcePingfederateRootDir> [-l <newPingFederateLicense>] [-c] [--release-notes-reviewed]";
    public static final String MODE_STANDARD = "-s";
    public static final String MODE_CUSTOM = "-c";
    public static final String OPERATIONAL_MODE_STANDALONE = "STANDALONE";
    public static final String OPERATIONAL_MODE_CLUSTERED_CONSOLE = "CLUSTERED_CONSOLE";
    public static final String OPERATIONAL_MODE_CLUSTERED_ENGINE = "CLUSTERED_ENGINE";
    public static final String OPERATIONAL_MODE_CLUSTERED_DUAL = "CLUSTERED_DUAL";
    static String sourcePingfederateDirPath = null;
    private static String destinationPingfederateDirPath = null;
    static String licenseFileLocation = "";
    static String mode = "-s";
    private static boolean skipUpgradeQuestions = false;
    private static String upgradeDir = null;
    private static Version sourceActualPFVersion = null;
    private static Version sourceReferencePFVersion = null;
    private static Version destinationPFVersion = null;
    private static String sourceOperationalMode = null;
    private static boolean bcfipsEnabled = false;

    public static void main(String[] args) {
        upgradeDir = System.getProperty("upgrade.home.dir");
        destinationPingfederateDirPath = System.getProperty("upgrade.home.dir") + File.separator + ".." + File.separator + "..";
        try {
            UpgradeUtility.parseArguments(args);
            UpgradeUtility.validateAndNormalizeArguments();
            UpgradeUtility.checkIfUpgraded();
            UpgradeUtility.setSourceOperationalMode();
            UpgradeUtility.validateAdminAPIAuthMethods();
            sourceActualPFVersion = UpgradeUtility.getPingFederateVersion(sourcePingfederateDirPath);
            sourceReferencePFVersion = UpgradeUtility.getPingFederateVersion(sourcePingfederateDirPath);
            destinationPFVersion = UpgradeUtility.getPingFederateVersion(destinationPingfederateDirPath);
            UpgradeUtility.validatePFVersions();
            UpgradeUtility.checkEnableBCFIPSMode();
            UpgradeUtility.writeLogHeader();
            UpgradeUtility.promptForPreUpgradeInputs();
            try {
                File sourcePFReferenceFilesDir = Utils.unzipDefaultPFInstall((String)Utils.getReferenceFilesDir((String)upgradeDir), (Version)sourceReferencePFVersion);
                PingFederateMigrator pfMigrator = new PingFederateMigrator(sourcePingfederateDirPath, destinationPingfederateDirPath, upgradeDir, sourceReferencePFVersion.toString(), mode, sourceOperationalMode, destinationPFVersion.toString(), licenseFileLocation);
                pfMigrator.execute();
                Utils.deleteFolder((File)sourcePFReferenceFilesDir);
            }
            catch (MigrationException e) {
                log.error("Upgrade utility encountered an exception. Exiting.", (Throwable)e);
            }
            catch (FileHandlingException e) {
                throw new UpgradeException("Error while handling file unzipping or deleting.", e);
            }
            finally {
                UpgradeUtility.createCompletedUpgradeFile();
            }
            UpgradeUtility.writeSummary();
        }
        catch (UpgradeUtilityException e) {
            log.error("Upgrade utility encountered an exception. Exiting.", (Throwable)e);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void checkEnableBCFIPSMode() throws UpgradeUtilityException {
        if (PropertyInfo.HSM_MODE.BCFIPS.name().equals(UpgradeUtility.getSourceHsmMode())) {
            BCFIPSStarter bcfipsStarter = BCFIPSStarter.forUpgradeUtility();
            bcfipsStarter.start();
            bcfipsEnabled = true;
        }
    }

    private static String getSourceHsmMode() throws UpgradeUtilityException {
        try {
            File sourceRunPropertiesFile = new File(sourcePingfederateDirPath + File.separator + "bin", "run.properties");
            Properties sourceProps = FilesUtils.loadProperties((File)sourceRunPropertiesFile);
            return StringUtils.trim((String)sourceProps.getProperty("pf.hsm.mode"));
        }
        catch (IOException e) {
            throw new UpgradeUtilityException("Unable to get pf.hsm.mode from source run.properties", e);
        }
    }

    private static void validatePFVersions() throws UpgradeUtilityException {
        try {
            sourceReferencePFVersion = Utils.resolveClosestSupportedSourceVersion((Version)sourceActualPFVersion, (Version)destinationPFVersion, (String)Utils.getReferenceFilesDir((String)upgradeDir), (String)sourcePingfederateDirPath);
        }
        catch (UnsupportedUpgradeVersionException e) {
            UpgradeUtility.throwSyntaxError(e.getMessage());
        }
        if (!destinationPFVersion.toString().equals(UpgradeUtility.getUpgradeUtilityVersion())) {
            UpgradeUtility.throwSyntaxError("Unable to complete upgrade. This tool is version " + UpgradeUtility.getUpgradeUtilityVersion() + " and does not support upgrading to PingFederate " + destinationPFVersion);
        }
    }

    private static void setSourceOperationalMode() throws UpgradeUtilityException {
        block8: {
            String opModePropertyName = "pf.operational.mode";
            try {
                File sourceRunPropertiesFile = new File(sourcePingfederateDirPath + File.separator + "bin", "run.properties");
                if (!sourceRunPropertiesFile.exists()) {
                    throw new UpgradeUtilityException("Unable to determine the Operational Mode of source PingFederate server. " + sourceRunPropertiesFile.getPath() + " does not exist.");
                }
                Properties sourceRunProperties = FilesUtils.loadProperties((File)sourceRunPropertiesFile);
                String opMode = sourceRunProperties.getProperty(opModePropertyName);
                if (opMode == null || opMode.trim().equals("")) {
                    throw new UpgradeUtilityException(opModePropertyName + " not set in source run.properties.");
                }
                if ((opMode = opMode.trim()).equalsIgnoreCase(OPERATIONAL_MODE_STANDALONE)) {
                    sourceOperationalMode = OPERATIONAL_MODE_STANDALONE;
                    break block8;
                }
                if (opMode.equalsIgnoreCase(OPERATIONAL_MODE_CLUSTERED_CONSOLE)) {
                    sourceOperationalMode = OPERATIONAL_MODE_CLUSTERED_CONSOLE;
                    break block8;
                }
                if (opMode.equalsIgnoreCase(OPERATIONAL_MODE_CLUSTERED_ENGINE)) {
                    sourceOperationalMode = OPERATIONAL_MODE_CLUSTERED_ENGINE;
                    break block8;
                }
                if (opMode.equalsIgnoreCase(OPERATIONAL_MODE_CLUSTERED_DUAL)) {
                    sourceOperationalMode = OPERATIONAL_MODE_CLUSTERED_DUAL;
                    break block8;
                }
                throw new UpgradeUtilityException(opModePropertyName + " in source run.properties is invalid: " + opMode);
            }
            catch (IOException e) {
                throw new UpgradeUtilityException("Unable to get " + opModePropertyName + " mode from source run.properties.", e);
            }
        }
    }

    private static void validateAdminAPIAuthMethods() throws UpgradeUtilityException {
        String adminApiAuthProperty = "pf.admin.api.authentication";
        try {
            AdminApiAuthPropertyValidator adminApiAuthPropertyValidator = new AdminApiAuthPropertyValidator((LoggingUtil)new LoggingUtilLog4j(UpgradeUtility.class));
            File sourceRunPropertiesFile = new File(sourcePingfederateDirPath + File.separator + "bin", "run.properties");
            Properties sourceProps = FilesUtils.loadProperties((File)sourceRunPropertiesFile);
            String adminApiAuthMethods = sourceProps.getProperty(adminApiAuthProperty);
            if (!adminApiAuthPropertyValidator.isAdminApiAuthPropertyValid(adminApiAuthMethods)) {
                throw new UpgradeUtilityException(adminApiAuthProperty + " in source run.properties is invalid: " + adminApiAuthMethods);
            }
        }
        catch (IOException e) {
            throw new UpgradeUtilityException("Unable to get " + adminApiAuthProperty + " from source run.properties", e);
        }
    }

    private static void validateAndNormalizeArguments() throws UpgradeUtilityException {
        sourcePingfederateDirPath = UpgradeUtility.validatePingFederateDirectory(sourcePingfederateDirPath, ARGUMENT_ID_SOURCE_PF_DIR, true);
        destinationPingfederateDirPath = UpgradeUtility.validatePingFederateDirectory(destinationPingfederateDirPath, ARGUMENT_ID_DESTINATION_PF_DIR, false);
    }

    private static String validatePingFederateDirectory(String path, String arg, boolean sourcePf) throws UpgradeUtilityException {
        try {
            File loginXmlFile;
            File pfDir = new File(path);
            String pfPath = pfDir.getCanonicalPath();
            if (!pfDir.exists()) {
                UpgradeUtility.throwSyntaxError(arg + " (" + pfPath + ") does not exist.");
            } else if (!pfDir.isDirectory()) {
                UpgradeUtility.throwSyntaxError(arg + " (" + pfPath + ") is not a directory.");
            } else {
                if (!pfDir.getName().equals("pingfederate")) {
                    File dir = new File(pfDir, "pingfederate");
                    if (dir.exists()) {
                        String newPath = dir.getCanonicalPath();
                        log.debug("Changing pfPath from " + pfPath + " to " + newPath);
                        pfPath = newPath;
                        pfDir = dir;
                    } else {
                        UpgradeUtility.throwSyntaxError(arg + " (" + pfDir + ") is not a PingFederate directory.");
                    }
                }
                if (!new File(pfDir, "bin" + File.separator + "run.properties").exists()) {
                    UpgradeUtility.throwSyntaxError(arg + " (" + pfPath + ") is not a PingFederate directory.");
                }
            }
            if (sourcePf && !(loginXmlFile = new File(pfPath + File.separator + "server" + File.separator + "default" + File.separator + "data" + File.separator + "config-store", "com.pingidentity.page.Login.xml")).exists()) {
                UpgradeUtility.throwSyntaxError(arg + " (" + pfPath + ") has never been configured.  Upgrade not needed.");
            }
            return pfPath;
        }
        catch (IOException e) {
            throw new UpgradeUtilityException("Error encountered while validating arguments. ", e);
        }
    }

    protected static void parseArguments(String[] args) {
        String srcPFDirPath = null;
        int argsLength = args.length;
        if (argsLength == 0) {
            UpgradeUtility.throwSyntaxError("Missing arguments");
        }
        int argumentLengthMax = 5;
        int argumentLengthMin = 1;
        if (argsLength < argumentLengthMin || argsLength > argumentLengthMax) {
            UpgradeUtility.throwSyntaxError("Invalid number of arguments detected.  Verify usage is correct.  Paths that contain spaces should be wrapped with quotes (\").");
        } else {
            srcPFDirPath = args[0];
            if (srcPFDirPath.endsWith(File.separator)) {
                srcPFDirPath = srcPFDirPath.substring(0, srcPFDirPath.length() - 1);
            }
            if (argsLength > 1) {
                block10: for (int argIndex = 1; argIndex < argsLength; ++argIndex) {
                    String argument;
                    switch (argument = args[argIndex]) {
                        case "-l": {
                            File licenseFile;
                            if (argIndex + 1 < argsLength) {
                                licenseFileLocation = args[argIndex + 1];
                            }
                            if (!(licenseFile = new File(licenseFileLocation)).exists()) {
                                UpgradeUtility.throwSyntaxError("The license file path provided does not exist: " + licenseFileLocation + System.lineSeparator() + "Verify usage is correct.  Paths that contain spaces should be wrapped with quotes (\").");
                            }
                            ++argIndex;
                            continue block10;
                        }
                        case "-c": {
                            mode = argument;
                            continue block10;
                        }
                        case "--release-notes-reviewed": {
                            skipUpgradeQuestions = true;
                            continue block10;
                        }
                        default: {
                            UpgradeUtility.throwSyntaxError("Invalid arguments.  Verify usage is correct.");
                        }
                    }
                }
            }
            sourcePingfederateDirPath = srcPFDirPath;
        }
    }

    protected static void throwSyntaxError(String msg) {
        System.err.println(msg);
        System.err.println();
        System.err.println("USAGE:");
        System.err.println("  <sourcePingfederateRootDir> [-l <newPingFederateLicense>] [-c] [--release-notes-reviewed]");
        System.err.println();
        System.err.println("<sourcePingfederateRootDir>\t\tThe full or relative path of the base directory where the existing PingFederate software (pingfederate/*) is installed");
        System.err.println("-l <newPingFederateLicense>\t\tOptional path and filename of the license to use for the upgraded PingFederate version");
        System.err.println("-c\t\t\t\t\tRun the utility in custom mode, allowing administrators to override several default migration steps");
        System.err.println("--release-notes-reviewed\t\tOptional flag indicating that the release notes have been reviewed");
        System.exit(1);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static Version getPingFederateVersion(String pingfederatePath) throws UpgradeException {
        Version version = null;
        File tempDir = null;
        FileInputStream pomPropertiesFIS = null;
        try {
            tempDir = FilesUtils.createTempDir();
            File pfStartupJar = new File(pingfederatePath, "bin" + File.separator + "pf-startup.jar");
            UnzipUtil.deployToFilesystem((String)tempDir.getPath(), (File)pfStartupJar);
            File pomPropertiesFile = new File(tempDir, "META-INF" + File.separator + "maven" + File.separator + "pingfederate" + File.separator + "pf-startup" + File.separator + "pom.properties");
            pomPropertiesFIS = new FileInputStream(pomPropertiesFile);
            Properties pomProperties = new Properties();
            pomProperties.load(pomPropertiesFIS);
            String versionFromProp = pomProperties.getProperty("version");
            if (versionFromProp != null) {
                version = new Version(versionFromProp);
            }
        }
        catch (MigrationException | IOException e) {
            throw new UpgradeException("Unable to retrieve PingFederate Version: " + pingfederatePath, e);
        }
        finally {
            if (tempDir != null && tempDir.exists()) {
                tempDir.delete();
            }
            if (pomPropertiesFIS != null) {
                try {
                    pomPropertiesFIS.close();
                }
                catch (IOException e) {
                    log.error("Error while closing pom.properties FileInputStream", (Throwable)e);
                }
            }
        }
        return version;
    }

    private static void writeLogHeader() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        log.info("************************************************************************************************************************");
        log.info("*  Date:   " + df.format(new Date()));
        if (MODE_STANDARD.equals(mode)) {
            log.info("*  Mode:   Standard");
        } else if ("-c".equals(mode)) {
            log.info("*  Mode:   Custom");
        }
        if (bcfipsEnabled) {
            log.info("*  BCFIPS: Enabled");
        }
        int labelWidth = Math.max(ARGUMENT_ID_SOURCE_PF_DIR.length(), ARGUMENT_ID_DESTINATION_PF_DIR.length());
        log.info("*");
        log.info("*  Source");
        if (sourceActualPFVersion.equals((Object)sourceReferencePFVersion)) {
            log.info(String.format("*    %-" + (labelWidth + 1) + "s  %s", "Version:", sourceActualPFVersion.toLogString()));
        } else {
            log.info(String.format("*    %-" + (labelWidth + 1) + "s  %s (Reference Version: %s)", "Version:", sourceActualPFVersion.toLogString(), sourceReferencePFVersion.toLogString()));
        }
        log.info(String.format("*    %-" + (labelWidth + 1) + "s  %s", "<sourcePingfederateRootDir>:", sourcePingfederateDirPath));
        log.info(String.format("*    %-" + (labelWidth + 1) + "s  %s", "Operational Mode:", sourceOperationalMode));
        log.info("*");
        log.info("*  Destination");
        log.info(String.format("*    %-" + (labelWidth + 1) + "s  %s", "Version:", destinationPFVersion.toLogString()));
        log.info(String.format("*    %-" + (labelWidth + 1) + "s  %s", "<destinationPingfederateRootDir>:", destinationPingfederateDirPath));
        log.info("************************************************************************************************************************");
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    private static void writeSummary() throws UpgradeUtilityException {
        File logFile = new File(upgradeDir + File.separator + "log", UPGRADE_LOG);
        try (LineIterator lineIterator = FileUtils.lineIterator((File)logFile);){
            int numberOfErrors = 0;
            int numberOFWarnings = 0;
            while (lineIterator.hasNext()) {
                String nextLine = lineIterator.nextLine();
                if (nextLine.startsWith("ERROR")) {
                    ++numberOfErrors;
                }
                if (!nextLine.startsWith("WARN")) continue;
                ++numberOFWarnings;
            }
            log.info("Upgrade completed with " + numberOfErrors + " error(s) and " + numberOFWarnings + " warning(s)");
        }
        catch (IOException e) {
            throw new UpgradeUtilityException("Unable to write summary", e);
        }
    }

    private static void checkIfUpgraded() {
        File file = new File(upgradeDir + File.separator + "log", UPGRADE_COMPLETE_FILE);
        if (file.exists()) {
            File logFileDir = new File(upgradeDir + File.separator + "log");
            System.err.println("The upgrade process has been run.  Please check the logs in folder " + logFileDir.getAbsolutePath() + " for the status of the upgrade.  If the upgrade did not complete successfully, please re-extract the archive and run the upgrade utility.");
            System.exit(1);
        }
    }

    private static void createCompletedUpgradeFile() throws UpgradeUtilityException {
        File logFile = new File(upgradeDir + File.separator + "log", UPGRADE_COMPLETE_FILE);
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), StandardCharsets.UTF_8));){
            bw.write("Source Version: " + sourceActualPFVersion.toLogString());
            bw.newLine();
            bw.write("Source Path: " + sourcePingfederateDirPath);
        }
        catch (IOException e) {
            throw new UpgradeUtilityException("Unable to create the completion file", e);
        }
    }

    private static String getUpgradeUtilityVersion() throws UpgradeUtilityException {
        InputStream is = null;
        try {
            is = UpgradeUtility.class.getResourceAsStream("/META-INF/maven/pingfederate/pf-upgrade-jar/pom.properties");
            Properties pomProps = new Properties();
            pomProps.load(is);
            String version = pomProps.getProperty("version");
            String string = new Version(version).toString();
            return string;
        }
        catch (Exception e) {
            String versionNumForInternalUserOnly = System.getProperty("uu.version.number.internal");
            if (versionNumForInternalUserOnly != null) {
                String string = versionNumForInternalUserOnly;
                return string;
            }
            throw new UpgradeUtilityException("Unable to get version number of upgrade utility", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("Unable to close input stream", (Throwable)e);
                }
            }
        }
    }

    private static void promptForPreUpgradeInputs() {
        if (skipUpgradeQuestions) {
            return;
        }
        System.out.println();
        ReleaseNotePrompt releaseNotePrompt = new ReleaseNotePrompt();
        UpgradeConsiderationPrompt upgradeConsiderationPrompt = new UpgradeConsiderationPrompt(sourceActualPFVersion, destinationPFVersion);
        releaseNotePrompt.prompt();
        upgradeConsiderationPrompt.prompt();
    }
}

