/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AltAuthnSourceDependentTemplateFileCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(AltAuthnSourceDependentTemplateFileCustomAction.class);
    private final String destinationVersion;

    public AltAuthnSourceDependentTemplateFileCustomAction(String destinationVersion) {
        this.destinationVersion = destinationVersion;
    }

    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File sourceConfig = new File(sourceFileParentDir, fileName);
        File destinationConfig = new File(destinationFileParentDir, fileName);
        Object extension = FilenameUtils.getExtension((String)fileName);
        if (!((String)extension).isEmpty()) {
            extension = "." + (String)extension;
        }
        File renamedDestinationConfig = new File(destinationFileParentDir, FilenameUtils.removeExtension((String)fileName) + "-default-" + this.destinationVersion + (String)extension);
        try {
            FileUtils.moveFile((File)destinationConfig, (File)renamedDestinationConfig);
            log.info("Rename " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()) + " to " + LogHelper.getInstance().getCleanPath(renamedDestinationConfig.getPath()));
        }
        catch (IOException e) {
            log.error("Unable to rename " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()) + " to " + LogHelper.getInstance().getCleanPath(renamedDestinationConfig.getPath()), (Throwable)e);
        }
        try {
            FilesUtils.copyfile((File)sourceConfig, (File)destinationConfig);
        }
        catch (IOException e) {
            throw new FileCustomActionException("Unable to migrate " + LogHelper.getInstance().getCleanPath(sourceConfig.getPath()), (Throwable)e);
        }
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        return false;
    }

    public boolean copyIfSourceDefaultMissing() {
        return false;
    }
}

