/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4j2ConfigFileCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(Log4j2ConfigFileCustomAction.class);
    private String destinationVersion;

    public Log4j2ConfigFileCustomAction(String destinationVersion) {
        this.destinationVersion = destinationVersion;
    }

    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        block4: {
            File sourceLog4jConfig = new File(sourceFileParentDir, fileName);
            File defaultSourceLog4jConfig = new File(sourceDefaultFileParentDir, fileName);
            File destinationLog4jXml = new File(destinationFileParentDir, fileName);
            try {
                if (FileUtils.contentEquals((File)sourceLog4jConfig, (File)defaultSourceLog4jConfig)) break block4;
                log.warn("We've detected that your logging configuration file (log4j2.xml) has been modified but changes could not be migrated. Manual updates required. Please see \"PingFederate Upgrade Utility User Guide\" for more details.");
                File renamedDestinationLog4jXml = new File(destinationFileParentDir, "log4j2-default-" + this.destinationVersion + ".xml");
                try {
                    FileUtils.moveFile((File)destinationLog4jXml, (File)renamedDestinationLog4jXml);
                    log.info("Rename " + LogHelper.getInstance().getCleanPath(destinationLog4jXml.getPath()) + " to " + LogHelper.getInstance().getCleanPath(renamedDestinationLog4jXml.getPath()));
                }
                catch (IOException e) {
                    log.error("Unable to rename " + LogHelper.getInstance().getCleanPath(destinationLog4jXml.getPath()) + " to " + LogHelper.getInstance().getCleanPath(renamedDestinationLog4jXml.getPath()), (Throwable)e);
                }
                FilesUtils.copyfile((File)sourceLog4jConfig, (File)destinationLog4jXml);
            }
            catch (IOException e) {
                throw new FileCustomActionException("Unable to migrate " + LogHelper.getInstance().getCleanPath(sourceLog4jConfig.getPath()), (Throwable)e);
            }
        }
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        return false;
    }

    public boolean copyIfSourceDefaultMissing() {
        return false;
    }
}

