/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4jConfigFileCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(Log4jConfigFileCustomAction.class);
    private String sourceVersion;

    public Log4jConfigFileCustomAction(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File sourceLog4jConfig = new File(sourceFileParentDir, fileName);
        File defaultSourceLog4jConfig = new File(sourceDefaultFileParentDir, fileName);
        File destinationLog4jXml = new File(destinationFileParentDir, fileName);
        try {
            if (!FileUtils.contentEquals((File)sourceLog4jConfig, (File)defaultSourceLog4jConfig)) {
                log.warn("We've detected that your logging configuration file (log4j.xml) has been modified but changes could not be migrated. Manual updates required. Please see \"PingFederate Upgrade Utility User Guide\" for more details.");
                File renamedDestinationLog4jXml = new File(destinationFileParentDir, "log4j-old-" + this.sourceVersion + ".xml");
                FilesUtils.copyfile((File)sourceLog4jConfig, (File)renamedDestinationLog4jXml);
                log.info("Rename " + LogHelper.getInstance().getCleanPath(destinationLog4jXml.getPath()) + " to " + LogHelper.getInstance().getCleanPath(renamedDestinationLog4jXml.getPath()));
                List<String> processedLines = this.searchLinesAndReplace(renamedDestinationLog4jXml);
                FileUtils.writeLines((File)renamedDestinationLog4jXml, processedLines);
            }
        }
        catch (IOException e) {
            throw new FileCustomActionException("Unable to migrate " + LogHelper.getInstance().getCleanPath(sourceLog4jConfig.getPath()), (Throwable)e);
        }
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        return false;
    }

    public boolean copyIfSourceDefaultMissing() {
        return false;
    }

    protected List<String> searchLinesAndReplace(File destinationLog4jXml) throws IOException {
        ArrayList<String> processedLines = new ArrayList<String>();
        List origLines = FileUtils.readLines((File)destinationLog4jXml, (String)"UTF-8");
        for (String line : origLines) {
            processedLines.add(this.searchLineAndReplace(line));
        }
        return processedLines;
    }

    private String searchLineAndReplace(String line) {
        HashMap<String, String> searchReplace = new HashMap<String, String>();
        searchReplace.put("org.jboss.logging.appender", "org.apache.log4j");
        searchReplace.put("org.jboss.logging.util", "org.apache.log4j.helpers");
        String processedLine = new String(line);
        for (Map.Entry e : searchReplace.entrySet()) {
            String key = (String)e.getKey();
            if (!processedLine.contains(key)) continue;
            processedLine = StringUtils.replace((String)processedLine, (String)key, (String)((String)e.getValue()));
        }
        return processedLine;
    }
}

