/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IWACustomAction
extends ArchiveFileCustomAction {
    private static final Logger log = LogManager.getLogger(IWACustomAction.class);

    public IWACustomAction(String mode) {
        super(mode);
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        try {
            if (fileName.startsWith("pf-iwa-authn-adapter")) {
                log.warn("A version of the IWA Adapter was detected in your source PingFederate server. As of November 2020, Ping Identity will be ending support for the PingFederate Integrated Windows Authentication (IWA) Integration Kit. The current IWA Integration Kit supports Kerberos and New Technology Lan Manager (NTLM) authentication. As IWA approaches end-of-life, support will be discontinued for NTLM-based authentication, and only Kerberos-based authentication will be supported moving forward. If your environment still uses NTLM, consult with Microsoft on strategies for migrating to Kerberos.\nTo avoid impacting the existing configuration, " + fileName + " will be copied to the destination PingFederate server. To migrate an existing IWA adapter configuration to the built-in PingFederate Kerberos adapter configuration, refer the article about Configuring a Kerberos Adapter instance in PingFederate Administrative manual.");
            }
            FilesUtils.copyfile((File)new File(sourceFileParentDir, fileName), (File)new File(destinationFileParentDir, fileName));
        }
        catch (IOException ioe) {
            throw new FileCustomActionException("Error while migrating " + sourceDefaultFileParentDir + File.separator + fileName, (Throwable)ioe);
        }
    }
}

