/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SalesforcePartnerApiCustomAction
extends ArchiveFileCustomAction {
    private final Logger log = LogManager.getLogger(SalesforcePartnerApiCustomAction.class);

    public SalesforcePartnerApiCustomAction(String mode) {
        super(mode);
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File deployDirectory = new File(sourceFileParentDir.getParentFile().getPath(), "deploy");
        this.log.debug("source deployDirectory: " + deployDirectory.getPath());
        String[] salesforceConnectorFiles = deployDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("salesforce");
            }
        });
        if (salesforceConnectorFiles.length > 0) {
            File sourceFile = new File(sourceFileParentDir, fileName);
            File destinationFile = new File(destinationFileParentDir, fileName);
            try {
                FilesUtils.copyfile((File)sourceFile, (File)destinationFile);
            }
            catch (IOException e) {
                throw new FileCustomActionException("Unable to migrate " + sourceFile.getPath());
            }
        }
    }
}

