/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.kit;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingfederate.migration.file.custom.kit.PingOneServiceKitCustomAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PingOneConnectorKitCustomAction
extends PingOneServiceKitCustomAction {
    private static final Logger log = LogManager.getLogger(PingOneConnectorKitCustomAction.class);
    private final String sourceFriendlyName;

    public PingOneConnectorKitCustomAction(String mode, String jarName, String destinationFriendlyName, String sourceFriendlyName) {
        super(mode, jarName, destinationFriendlyName);
        this.sourceFriendlyName = sourceFriendlyName;
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        block5: {
            try {
                File sourceFile = new File(sourceFileParentDir, fileName);
                Collection destinationJars = FileUtils.listFiles((File)destinationFileParentDir, (IOFileFilter)new WildcardFileFilter(this.jarName + "*.jar"), null);
                if (destinationJars.size() == 0) {
                    log.warn("Expected " + this.jarName + " jar in " + destinationFileParentDir + " but file does not exist.");
                    FilesUtils.copyfile((File)sourceFile, (File)new File(destinationFileParentDir, fileName));
                    break block5;
                }
                if (destinationJars.size() == 1) {
                    String destinationFileName;
                    File destinationJar = (File)destinationJars.iterator().next();
                    String sourceFileName = sourceFile.getName();
                    if (!sourceFileName.equals(destinationFileName = destinationJar.getName())) {
                        log.warn("The new version of " + fileName + " is " + destinationFileName + ". We recommend you manually delete your existing connections created using " + this.sourceFriendlyName + ", recreate new connections using " + this.friendlyName + " and delete the " + this.getDestinationDeployDirectoryPath() + fileName + ". If you are not using " + this.sourceFriendlyName + ", delete the " + this.getDestinationDeployDirectoryPath() + fileName + ".");
                        FilesUtils.copyfile((File)sourceFile, (File)new File(destinationFileParentDir, fileName));
                    }
                    break block5;
                }
                throw new FileCustomActionException("More than one " + this.jarName + " jar was found in " + destinationFileParentDir + ". Unable to migrate " + sourceFile.getPath());
            }
            catch (FileCustomActionException | IOException e) {
                throw new FileCustomActionException("Unable to migrate " + sourceDefaultFileParentDir + File.separator + fileName, e);
            }
        }
    }

    private String getDestinationDeployDirectoryPath() {
        return "<destinationPingfederateRootDir>" + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator;
    }
}

