/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.migrator;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.pingcommons.upgrade.file.PropertyMigrator;
import com.pingidentity.pingfederate.migration.AdminRolePropertyName;
import com.pingidentity.pingfederate.migration.migrator.AdminRolePropertyAppender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdminRolePropertyMigrator
implements PropertyMigrator {
    private static final Logger log = LogManager.getLogger(AdminRolePropertyAppender.class);
    private final String sourceVersion;
    private final AdminRolePropertyName adminRolePropertyName;

    public AdminRolePropertyMigrator(AdminRolePropertyName adminRolePropertyNames, String sourceVersion) {
        this.adminRolePropertyName = adminRolePropertyNames;
        this.sourceVersion = sourceVersion;
    }

    public String migrateProperty(String propertyName, String srcValue, String srcDefault, String dstDefault, Properties srcValues, Properties srcDefaults, Properties dstDefaults, String fileName) {
        String result = null;
        String adminRoleName = this.adminRolePropertyName.getAdminPropertyNameOrGroupPropertyName(propertyName);
        String expressionAdminRoleName = this.adminRolePropertyName.getEaAdminPropertyNameOrGroupPropertyName(propertyName);
        String dataCollectionAdminRoleName = this.adminRolePropertyName.getDcAdminPropertyNameOrGroupPropertyName(propertyName);
        try {
            if (Version.compare((String)this.sourceVersion, (String)"10.1.0") < 0 && propertyName.startsWith(expressionAdminRoleName) && StringUtils.isEmpty((String)srcValues.getProperty(propertyName))) {
                String[] splitPropertyName = propertyName.split(expressionAdminRoleName);
                if (splitPropertyName.length == 0) {
                    result = srcValues.getProperty(adminRoleName);
                } else if (splitPropertyName.length > 1) {
                    result = srcValues.getProperty(expressionAdminRoleName + splitPropertyName[1]);
                }
            }
            if (Version.compare((String)this.sourceVersion, (String)"12.2.0") < 0 && propertyName.startsWith(dataCollectionAdminRoleName) && StringUtils.isEmpty((String)srcValues.getProperty(propertyName)) && (propertyName.equals(this.adminRolePropertyName.getDcRole()) || propertyName.equals("role.dataCollectionAdmin.subject.1"))) {
                result = AdminRolePropertyMigrator.getDataCollectionRole(srcValues, this.adminRolePropertyName);
            }
        }
        catch (MigrationException e) {
            log.warn("Unable to migrate " + propertyName + ". " + e.getMessage());
        }
        if (StringUtils.isNotEmpty(result)) {
            log.info("Update " + fileName + " Change property " + propertyName + " from " + LogHelper.getInstance().getValueForLog(propertyName, (Object)dstDefault) + " to " + LogHelper.getInstance().getValueForLog(propertyName, result) + ".");
        }
        return result;
    }

    public static String getDataCollectionRole(Properties sourceProperties, AdminRolePropertyName adminRolePropertyNames) {
        List<String> admins = AdminRolePropertyMigrator.getUsersWithRole(adminRolePropertyNames.getAdminRole(), sourceProperties);
        List<String> cryptoAdmins = AdminRolePropertyMigrator.getUsersWithRole(adminRolePropertyNames.getCryptoRole(), sourceProperties);
        List<String> userAdmins = AdminRolePropertyMigrator.getUsersWithRole(adminRolePropertyNames.getUserAdminRole(), sourceProperties);
        List adminsWithAllRoles = admins.stream().filter(cryptoAdmins::contains).filter(userAdmins::contains).collect(Collectors.toList());
        return String.join((CharSequence)",", adminsWithAllRoles);
    }

    private static List<String> getUsersWithRole(String roleName, Properties sourceProperties) {
        String role;
        List<String> users = new ArrayList<String>();
        if (roleName != null && (role = sourceProperties.getProperty(roleName)) != null) {
            String[] names = role.split(",");
            users = Arrays.asList(names);
            users.replaceAll(String::trim);
        }
        return users;
    }
}

