/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.prompts;

import com.pingidentity.common.upgrade.Version;
import com.pingidentity.pingfederate.migration.prompts.Prompt;
import com.pingidentity.pingfederate.migration.prompts.SimplePrompt;
import com.pingidentity.pingfederate.migration.util.DocsHelper;

public final class UpgradeConsiderationPrompt
implements Prompt {
    private static final String QUESTION = "Have you read the applicable upgrade considerations between the source and target versions? (y/n) [n] ";
    private static final String EXPECTED_ANSWER = "y";
    private final Prompt prompt;

    public UpgradeConsiderationPrompt(Version sourceVersion, Version targetVersion) {
        Prompt.FailureHandler failureHandler = () -> {
            int sourceMajor = Math.max(sourceVersion.getMajor(), 6);
            int targetMajor = targetVersion.getMajor();
            String msg = "Please review the relevant upgrade considerations to ensure your upgrade completes successfully.";
            System.out.println();
            System.out.println(msg);
            System.out.println();
            for (int i = targetMajor; i >= sourceMajor; --i) {
                String documentationUrl = DocsHelper.getDocumentationUrl("PingFed-UpgradeConsiderations" + i + "x");
                System.out.printf("Upgrade considerations from %d.x: %s%n", i, documentationUrl);
            }
            System.exit(1);
        };
        this.prompt = new SimplePrompt(QUESTION, EXPECTED_ANSWER, failureHandler);
    }

    @Override
    public boolean prompt() {
        return this.prompt.prompt();
    }
}

