/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.util.hivemodule;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.pingfederate.migration.util.hivemodule.HivemoduleHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class HivemoduleConfGenerationHelper
extends HivemoduleHelper {
    private static final Logger log = LogManager.getLogger(HivemoduleConfGenerationHelper.class);
    private static final String SERVICE_POINTS_CONF = "service-points.conf";
    private static final String PROPERTY_NAME_SEPARATOR = ".";

    public static void generateServicePointsConf(File destinationFileParentDir, Map<String, String> sourceServicePointsMap) throws FileCustomActionException {
        File destFile = new File(destinationFileParentDir, SERVICE_POINTS_CONF);
        if (!destFile.exists()) {
            throw new FileCustomActionException("Failed to open " + LogHelper.getInstance().getCleanPath(destFile.getAbsolutePath()));
        }
        try {
            List lines = FileUtils.readLines((File)destFile, (Charset)StandardCharsets.UTF_8);
            for (int i = 0; i < lines.size(); ++i) {
                String key;
                int index;
                String line = (String)lines.get(i);
                if (line.startsWith("#") || (index = line.indexOf("=")) == -1 || !sourceServicePointsMap.containsKey(key = line.substring(0, line.indexOf("=")))) continue;
                lines.set(i, key + "=" + sourceServicePointsMap.get(key));
            }
            FileUtils.writeLines((File)destFile, (Collection)lines);
        }
        catch (IOException e) {
            throw new FileCustomActionException("Failed to generate " + LogHelper.getInstance().getCleanPath(destinationFileParentDir.getPath()) + File.pathSeparator + SERVICE_POINTS_CONF, (Throwable)e);
        }
    }

    public Map<String, String> getSourceServicePointsMap(File fileParentDir, String fileName) throws FileCustomActionException {
        XmlObject sourceHivemoduleXMLXmlDoc;
        try {
            sourceHivemoduleXMLXmlDoc = XmlObject.Factory.parse((File)fileParentDir);
        }
        catch (Exception e) {
            throw new FileCustomActionException("Unable to parse " + this.logHelper.getCleanPath(fileParentDir.getPath()), (Throwable)e);
        }
        Map<String, String> sourceServicePointsMap = this.buildServicePointMapXMLDoc(sourceHivemoduleXMLXmlDoc);
        if (sourceServicePointsMap.isEmpty()) {
            throw new FileCustomActionException("Invalid " + fileName + ".  Services not found in " + this.logHelper.getCleanPath(fileParentDir.getPath()));
        }
        this.logDeprecatedServiceUsageMessages(sourceServicePointsMap);
        return this.transformServicePointMap(sourceServicePointsMap);
    }

    private void logDeprecatedServiceUsageMessages(Map<String, String> sourceServicePointsMap) {
        String interRequestStateMgmt = sourceServicePointsMap.get("InterRequestStateMgmt");
        if ("org.sourceid.saml20.service.impl.cookie.InterReqStateMgmtCookieImpl".equals(interRequestStateMgmt)) {
            log.warn("Cookie based \"Inter-Request State-Management\" (org.sourceid.saml20.service.impl.cookie.InterReqStateMgmtCookieImpl) has been deprecated as of PingFederate 9.2 and may be removed in future releases. It is recommended to use the Inter-Request State-Management proxy implementation (org.sourceid.saml20.service.impl.proxy.InterRequestStateMgmtProxy) instead.");
        }
    }

    private Map<String, String> buildServicePointMapXMLDoc(XmlObject hivemoduleXmlDoc) {
        HashMap<String, String> servicePointsMap = new HashMap<String, String>();
        XmlCursor docCurser = hivemoduleXmlDoc.newCursor();
        if (docCurser.hasNextToken()) {
            do {
                docCurser.toNextToken();
                if (!docCurser.isStart() || !docCurser.getName().getLocalPart().equals("service-point")) continue;
                XmlObject servicePointObject = docCurser.getObject();
                servicePointsMap.put(HivemoduleHelper.getServicePointIdFromXML(servicePointObject), HivemoduleHelper.getClassFromServicePoint(servicePointObject));
            } while (docCurser.hasNextToken());
        }
        return servicePointsMap;
    }

    public Map<String, String> transformServicePointMap(Map<String, String> servicePointMap) {
        HashMap<String, String> outputMap = new HashMap<String, String>();
        for (Map.Entry<String, String> servicePoint : servicePointMap.entrySet()) {
            String id = servicePoint.getKey();
            outputMap.put(this.transformServicePointId(id), servicePoint.getValue());
        }
        return outputMap;
    }

    private String transformServicePointId(String servicePointId) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] arr = servicePointId.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char cur = arr[i];
            if (i == 0 || cur >= 'A' && cur <= 'Z' && i + 1 < arr.length && arr[i + 1] >= 'a' && arr[i + 1] <= 'z') {
                stringBuilder.append(PROPERTY_NAME_SEPARATOR).append(Character.toLowerCase(cur));
                continue;
            }
            stringBuilder.append(Character.toLowerCase(cur));
        }
        stringBuilder.delete(0, 1);
        return stringBuilder.toString();
    }
}

