/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.ISODateTimeFormat;

@Provider
@Produces(value={"application/json"})
public class ApiContextProvider
implements ContextResolver<ObjectMapper> {
    final ObjectMapper mapper = ApiContextProvider.makeObjectMapper();

    public static ObjectMapper makeObjectMapper() {
        ObjectMapper objMapper = new ObjectMapper();
        objMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule adminApiModule = new SimpleModule("AdminApiModule");
        adminApiModule.addDeserializer(String.class, (JsonDeserializer)new StringTrimDeserializer());
        adminApiModule.addDeserializer(URL.class, (JsonDeserializer)new URLDeserializer());
        adminApiModule.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        adminApiModule.addSerializer((JsonSerializer)new DateSerializer());
        objMapper.registerModule((Module)adminApiModule);
        return objMapper;
    }

    public ObjectMapper getContext(Class<?> arg0) {
        return this.mapper;
    }

    private static class DateSerializer
    extends JsonSerializer<Date> {
        private DateSerializer() {
        }

        public void serialize(Date date, JsonGenerator gen, SerializerProvider delegate) throws IOException, JsonProcessingException {
            String val = ISODateTimeFormat.dateTime().withZoneUTC().print(date.getTime());
            gen.writeString(val);
        }

        public Class<Date> handledType() {
            return Date.class;
        }
    }

    private static class DateDeserializer
    extends JsonDeserializer<Date> {
        private StringDeserializer delegate = new StringDeserializer();

        private DateDeserializer() {
        }

        public Date deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
            String rawField = this.delegate.deserialize(jp, ctx);
            String trimmedStr = StringUtils.trimToNull((String)rawField);
            try {
                return ISODateTimeFormat.dateTimeParser().parseDateTime(trimmedStr).toDate();
            }
            catch (IllegalArgumentException e) {
                throw ctx.mappingException("Invalid date-time format: " + rawField);
            }
        }
    }

    private static class URLDeserializer
    extends StdScalarDeserializer<URL> {
        private static final long serialVersionUID = 1L;

        public URLDeserializer() {
            super(URL.class);
        }

        public URL deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
            String url = this._parseString(jp, ctx);
            URL result = null;
            try {
                result = new URL(url);
            }
            catch (MalformedURLException e) {
                throw ctx.mappingException("Invalid URL: " + url);
            }
            return result;
        }
    }

    private static class StringTrimDeserializer
    extends JsonDeserializer<String> {
        private StringDeserializer delegate = new StringDeserializer();

        private StringTrimDeserializer() {
        }

        public String deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
            return StringUtils.trimToNull((String)this.delegate.deserialize(jp, ctx));
        }
    }
}

