/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api;

import com.pingidentity.pf.common.api.ApiMessageEnum;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApiMessageProperties {
    private static final Log log = LogFactory.getLog(ApiMessageProperties.class);
    private final Properties messages = new Properties();

    public ApiMessageProperties(String messageResourcePath) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (InputStream input = classLoader.getResourceAsStream(messageResourcePath);){
            this.messages.load(input);
        }
        catch (IOException e) {
            log.error((Object)("Error loading resource " + messageResourcePath), (Throwable)e);
        }
    }

    public String getMessage(String key) {
        return this.messages.getProperty(key);
    }

    public String getMessage(String key, Object[] params) {
        String message = this.messages.getProperty(key);
        if (message == null) {
            return null;
        }
        return MessageFormat.format(message, params);
    }

    public String getMessage(ApiMessageEnum key) {
        return this.messages.getProperty(key.getMsgKey());
    }

    public String getMessage(ApiMessageEnum key, Object[] params) {
        String message = this.messages.getProperty(key.getMsgKey());
        if (message == null) {
            return null;
        }
        return MessageFormat.format(message, params);
    }
}

