/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.pingidentity.pf.common.api.CommonApiMsgKey;
import com.pingidentity.pf.common.api.exception.ValidationErrorException;
import com.pingidentity.pf.common.api.model.ApiResult;
import com.pingidentity.pf.common.api.model.CommonApiResultFactory;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.pf.common.api.validator.error.ValidationErrorFactory;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;

@Provider
@Produces(value={"application/json"})
public class JsonMappingExceptionMapper
implements ExceptionMapper<JsonMappingException> {
    public Response toResponse(JsonMappingException mappingException) {
        int httpStatus = 400;
        ApiResult result = CommonApiResultFactory.create(CommonApiMsgKey.validation_error);
        if (mappingException.getCause() instanceof ValidationErrorException) {
            ValidationErrorException validationErrorException = (ValidationErrorException)mappingException.getCause();
            result.setValidationErrors(validationErrorException.getValidationErrors());
            httpStatus = validationErrorException.getHttpStatus();
        } else {
            List references = mappingException.getPath();
            ArrayList<Object> fields = new ArrayList<Object>();
            for (JsonMappingException.Reference ref : references) {
                String fieldName = ref.getFieldName();
                if (fieldName != null) {
                    fields.add(fieldName);
                    continue;
                }
                if (ref.getIndex() < 0) continue;
                Object prevFieldName = (String)fields.remove(fields.size() - 1);
                prevFieldName = (String)prevFieldName + "[" + ref.getIndex() + "]";
                fields.add(prevFieldName);
            }
            String fieldPath = StringUtils.join(fields, (char)'.');
            CommonApiMsgKey messageKey = CommonApiMsgKey.request_incorrectly_formatted;
            boolean includeExceptionMsg = true;
            Object[] msgParams = new Object[]{};
            if (mappingException instanceof UnrecognizedPropertyException) {
                messageKey = CommonApiMsgKey.invalid_json_field;
                includeExceptionMsg = false;
                msgParams = new Object[]{fieldPath};
            } else if (mappingException instanceof InvalidFormatException && ((InvalidFormatException)mappingException).getTargetType().isEnum()) {
                InvalidFormatException enumException = (InvalidFormatException)mappingException;
                messageKey = CommonApiMsgKey.invalid_enum;
                includeExceptionMsg = false;
                msgParams = new Object[]{enumException.getTargetType().getSimpleName()};
            }
            ValidationError error = ValidationErrorFactory.getInstance().create(messageKey, fieldPath, msgParams);
            if (includeExceptionMsg) {
                error.setDeveloperMessage(mappingException.getMessage());
            }
            result.appendError(error);
        }
        return Response.status((int)httpStatus).entity((Object)result).build();
    }
}

