/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api.audit;

import com.pingidentity.pf.common.api.authn.ApiAuthenticationType;
import com.pingidentity.sdk.logging.LoggingUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class ApiAuditLogger {
    private static final Map<String, ApiAuditLogger> instances = new HashMap<String, ApiAuditLogger>();
    private final Logger log;
    private static final String UNKNOWN = "unknown";

    public static synchronized ApiAuditLogger getInstance(String loggerName) {
        if (instances.containsKey(loggerName)) {
            return instances.get(loggerName);
        }
        ApiAuditLogger logger = new ApiAuditLogger(loggerName);
        instances.put(loggerName, logger);
        return logger;
    }

    private ApiAuditLogger(String loggerName) {
        this.log = LogManager.getLogger((String)loggerName);
    }

    public void setUsername(String username) {
        ThreadContext.put((String)Key.USERNAME.getId(), (String)username);
    }

    public void setAuthenticationType(ApiAuthenticationType authType) {
        ThreadContext.put((String)Key.AUTHENTICATION_TYPE.getId(), (String)authType.toString());
    }

    public void setAccessTokenHash(String accessToken) {
        Optional.ofNullable(LoggingUtil.calculateHashForLogging((String)accessToken)).ifPresent(hash -> ThreadContext.put((String)Key.AT_HASH.getId(), (String)hash));
    }

    public void setJti(String jti) {
        ThreadContext.put((String)Key.JTI.getId(), (String)jti);
    }

    public void setClientIpAddress(String clientIp) {
        ThreadContext.put((String)Key.CLIENT_IP_ADDRESS.getId(), (String)clientIp);
    }

    public void setPartnerId(String partnerId) {
        ThreadContext.put((String)Key.PARTNER_ID.getId(), (String)partnerId);
    }

    public void setHttpMethod(String httpMethod) {
        ThreadContext.put((String)Key.HTTP_METHOD.getId(), (String)httpMethod);
    }

    public void setUrl(String url) {
        ThreadContext.put((String)Key.URL.getId(), (String)url);
    }

    public void setHttpStatus(int status) {
        ThreadContext.put((String)Key.HTTP_STATUS.getId(), (String)Integer.toString(status));
    }

    public void setRequestParam(String name, String value) {
        this.setParam(Key.REQUEST.getId(), name, value);
    }

    public void setResponseParam(String name, String value) {
        this.setParam(Key.RESPONSE.getId(), name, value);
    }

    private void setParam(String key, String name, String value) {
        String mapValue = ThreadContext.get((String)key);
        Object valueToStore = mapValue == null ? this.getNameValuePair(name, value) : mapValue + "," + this.getNameValuePair(name, value);
        ThreadContext.put((String)key, (String)valueToStore);
    }

    public void logRequest() {
        for (Key key : Key.values()) {
            String val = ThreadContext.get((String)key.getId());
            if (val != null) continue;
            ThreadContext.put((String)key.getId(), (String)UNKNOWN);
        }
        this.log.info("");
    }

    public void clearContext() {
        for (Key key : Key.values()) {
            ThreadContext.remove((String)key.getId());
        }
    }

    protected String getNameValuePair(String name, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("=");
        sb.append(value);
        return sb.toString();
    }

    public static enum Key {
        USERNAME("api.user"),
        AUTHENTICATION_TYPE("api.authtype"),
        AT_HASH("athash"),
        JTI("jti"),
        CLIENT_IP_ADDRESS("api.clientip"),
        PARTNER_ID("api.partnerid"),
        HTTP_METHOD("api.httpmethod"),
        URL("api.url"),
        HTTP_STATUS("api.status"),
        REQUEST("api.request"),
        RESPONSE("api.response");

        private String id;

        private Key(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

