/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api.filter;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;

public class ResourceFilters
implements ResourceFilterFactory {
    private static final List<ResourceFilter> NO_CACHE_FILTERS = Arrays.asList(new CacheResponseFilter("no-cache, no-store"), new PragmaResponseFilter("no-cache"), new ExpiresFilter("0"));

    public List<ResourceFilter> create(AbstractMethod am) {
        return NO_CACHE_FILTERS;
    }

    private static class ExpiresFilter
    implements ResourceFilter,
    ContainerResponseFilter {
        private final String headerValue;

        ExpiresFilter(String headerValue) {
            this.headerValue = headerValue;
        }

        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            MultivaluedMap m = response.getHttpHeaders();
            m.putSingle((Object)"Expires", (Object)this.headerValue);
            return response;
        }
    }

    private static class PragmaResponseFilter
    implements ResourceFilter,
    ContainerResponseFilter {
        private final String headerValue;

        PragmaResponseFilter(String headerValue) {
            this.headerValue = headerValue;
        }

        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            MultivaluedMap m = response.getHttpHeaders();
            m.putSingle((Object)"Pragma", (Object)this.headerValue);
            return response;
        }
    }

    private static class CacheResponseFilter
    implements ResourceFilter,
    ContainerResponseFilter {
        private final List<Object> headerValues;

        CacheResponseFilter(String ... headerValues) {
            this.headerValues = new ArrayList<Object>(headerValues.length);
            for (String headerValue : headerValues) {
                this.headerValues.add(headerValue);
            }
        }

        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            response.getHttpHeaders().put((Object)"Cache-Control", this.headerValues);
            return response;
        }
    }
}

