/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api.validator.error;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.CommonApiMessages;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;

@ApiModel(description="A data input validation error.")
public class ValidationError {
    private String message;
    private String developerMessage;
    private String fieldPath;
    private String errorId;
    private Object[] messageParams;

    protected ValidationError(Builder<?> builder) {
        this.message = builder.message;
        this.developerMessage = builder.developerMessage;
        this.fieldPath = builder.fieldPath;
        this.errorId = builder.errorId;
        this.messageParams = builder.messageParams;
        if (builder.messageKey != null && builder.messageParams != null && builder.messageParams.length > 0) {
            this.message = CommonApiMessages.getMessage(builder.messageKey.getMsgKey(), builder.messageParams);
        } else if (builder.messageKey != null) {
            this.message = CommonApiMessages.getMessage(builder.messageKey.getMsgKey());
        }
    }

    public ValidationError(String errorId, String message, String fieldPath) {
        this.errorId = errorId;
        this.message = message;
        this.fieldPath = fieldPath;
    }

    public ValidationError(String errorId, String message, String fieldPath, String developerMessage) {
        this.errorId = errorId;
        this.message = message;
        this.developerMessage = developerMessage;
        this.fieldPath = fieldPath;
    }

    @ApiModelProperty(position=10, value="Error identifier.")
    public String getErrorId() {
        return this.errorId;
    }

    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }

    @ApiModelProperty(position=20, value="User-friendly error description.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @ApiModelProperty(position=30, value="Developer-oriented error message, if available.")
    public String getDeveloperMessage() {
        return this.developerMessage;
    }

    public void setDeveloperMessage(String developerMessage) {
        this.developerMessage = developerMessage;
    }

    @ApiModelProperty(position=40, value="The path to the model field to which the error relates, if one exists.", notes="In a user interface, this attribute can be used to associate the error with a specific location on the page. If models are nested, dot-notation is used to specify fields in sub-models.")
    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    @JsonIgnore
    public Object[] getMessageParams() {
        return this.messageParams != null ? Arrays.copyOf(this.messageParams, this.messageParams.length) : null;
    }

    public void setMessageParams(Object[] params) {
        this.messageParams = params != null ? Arrays.copyOf(params, params.length) : null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ErrorId: ");
        builder.append(this.errorId);
        builder.append("\nMessage: ");
        builder.append(this.message);
        builder.append("\nDev Message: ");
        builder.append(this.developerMessage);
        builder.append("\nField Path: ");
        builder.append(this.fieldPath);
        builder.append("\n");
        return builder.toString();
    }

    public static class Builder<T extends Builder<T>> {
        private String message;
        private String developerMessage;
        private String fieldPath;
        private String errorId;
        private Object[] messageParams;
        private ApiMessageEnum messageKey;

        public T message(String message) {
            this.message = message;
            return (T)this;
        }

        public T developerMessage(String developerMessage) {
            this.developerMessage = developerMessage;
            return (T)this;
        }

        public T fieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
            return (T)this;
        }

        public T errorId(String errorId) {
            this.errorId = errorId;
            return (T)this;
        }

        public T messageParams(Object[] messageParams) {
            this.messageParams = messageParams != null ? Arrays.copyOf(messageParams, messageParams.length) : null;
            return (T)this;
        }

        public T messageKey(ApiMessageEnum messageKey) {
            this.messageKey = messageKey;
            return (T)this;
        }

        public ValidationError build() {
            return new ValidationError(this);
        }
    }
}

