/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api.validator.error;

import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.CommonApiMessages;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidationErrorFactory {
    private static final ValidationErrorFactory instance = new ValidationErrorFactory();
    private static final Log log = LogFactory.getLog(ValidationErrorFactory.class);

    protected ValidationErrorFactory() {
    }

    public static ValidationErrorFactory getInstance() {
        return instance;
    }

    protected String getMessage(String errorId) {
        return CommonApiMessages.getMessage(errorId);
    }

    protected String getMessage(String errorId, Object[] params) {
        return CommonApiMessages.getMessage(errorId, params);
    }

    public ValidationError create(ApiMessageEnum errorId, String fieldPath) {
        return this.create(errorId, fieldPath, (Object[])null);
    }

    public ValidationError create(ApiMessageEnum errorId, String fieldPath, Object ... messageParams) {
        String errorMessage = null;
        errorMessage = messageParams == null || messageParams.length == 0 ? this.getMessage(errorId.getMsgKey()) : this.getMessage(errorId.getMsgKey(), messageParams);
        if (errorMessage == null) {
            log.warn((Object)("No message found for error ID " + errorId));
        }
        String devMessage = this.getMessage(errorId.getMsgKey() + "_DEV");
        ValidationError result = new ValidationError(errorId.getMsgKey(), errorMessage, fieldPath, devMessage);
        result.setMessageParams(messageParams);
        return result;
    }

    public ValidationError create(String messageKey, String errorMessage, String fieldPath) {
        ValidationError result = new ValidationError(messageKey, errorMessage, fieldPath, null);
        return result;
    }
}

