/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity;

import com.pingidentity.common.PingSimpleDateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Converter {
    private static String PF_INTERNAL_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static Log log = LogFactory.getLog(Converter.class);

    public static String datetime(String inputDate, String pattern) throws ParseException {
        String cannonicalizedDateStr;
        if (inputDate == null || "".equals(inputDate.trim()) || pattern == null || "".equals(pattern)) {
            return null;
        }
        SimpleDateFormat dateFormatter = pattern.endsWith("Z") ? new PingSimpleDateFormat(pattern) : new SimpleDateFormat(pattern);
        try {
            Date date = dateFormatter.parse(inputDate);
            SimpleDateFormat pfInternalDateFormatter = new SimpleDateFormat(PF_INTERNAL_DATE_FORMAT);
            cannonicalizedDateStr = pfInternalDateFormatter.format(date);
        }
        catch (ParseException e) {
            log.error((Object)("Exception in parsing date " + inputDate + " with pattern " + pattern));
            throw e;
        }
        return cannonicalizedDateStr;
    }

    public static Date str2Date(String dateStr) throws ParseException {
        SimpleDateFormat pfInternalDateFormatter = new SimpleDateFormat(PF_INTERNAL_DATE_FORMAT);
        return pfInternalDateFormatter.parse(dateStr);
    }
}

