/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.fragment;

import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSelectorVisitor;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.AuthnSourceKeyVisitor;
import com.pingidentity.authnselection.FragmentSourceKeyVisitor;
import com.pingidentity.authnselection.LeafNodeVisitor;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.authnselection.xmlbinding.AstNodeType;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.pingcommons.util.tree.PreOrderTraversal;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import comPfPolicyFragment.pingidentity.PolicyFragmentConfigType;
import comPfPolicyFragment.pingidentity.PolicyFragmentDocument;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AbstractPolicyTreeConfigManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.Searchable;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;
import org.sourceid.websso.authn.AuthnPolicyUtil;

public class PolicyFragmentManagerImpl
extends AbstractPolicyTreeConfigManager
implements PolicyFragmentManager,
AutoReloadable {
    private static final Log LOG = LogFactory.getLog(PolicyFragmentManagerImpl.class);
    private static final String FRAGMENTS_DIR = "fragments";
    private final XmlLoader xmlLoader;
    private final Map<String, PolicyFragment> fragmentMap = new CaseInsensitiveMap();
    private static final Comparator<PolicyFragment> COMPARE_BY_NAME_DOWN = (fragment1, fragment2) -> fragment1.getName().compareToIgnoreCase(fragment2.getName());

    public PolicyFragmentManagerImpl(XmlLoader xmlLoader, Mediator mediator) {
        this.xmlLoader = xmlLoader;
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(PolicyFragment fragment) {
        PolicyFragmentManagerImpl policyFragmentManagerImpl = this;
        synchronized (policyFragmentManagerImpl) {
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                boolean isUpdate;
                if (fragment.getId() == null) {
                    fragment.setId(AuthnPolicyUtil.getDefault().generateId());
                    isUpdate = false;
                } else {
                    isUpdate = this.doDelete(fragment.getId());
                }
                PolicyFragmentDocument doc = this.convertToXmlDoc(fragment);
                String filename = fragment.getId() + ".xml";
                this.xmlLoader.save(this.getFragmentsFolder(), filename, (XmlObject)doc);
                auditLoggerScope.log(AdminAuditLogger.Component.POLICY_FRAGMENT, isUpdate ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE, fragment.getId());
                this.loadXmlFile(this.getFragmentsFolder(), filename);
            }
        }
    }

    @Override
    public synchronized void delete(String id) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.delete(this.getFragmentsFolder(), id + ".xml");
            auditLoggerScope.log(AdminAuditLogger.Component.POLICY_FRAGMENT, AdminAuditLogger.Event.DELETE, id);
        }
        this.fragmentMap.remove(id);
    }

    private synchronized boolean doDelete(String id) {
        this.xmlLoader.delete(this.getFragmentsFolder(), id + ".xml");
        PolicyFragment existing = this.fragmentMap.remove(id);
        return existing != null;
    }

    @Override
    public PolicyFragment getFragment(String id) {
        return this.fragmentMap.get(id);
    }

    @Override
    public List<PolicyFragment> getFragments() {
        return Collections.unmodifiableList(new ArrayList<PolicyFragment>(this.fragmentMap.values()));
    }

    private synchronized void loadConfig() {
        FileFilter filter;
        File[] xmlFiles;
        this.fragmentMap.clear();
        File fragmentsDir = new File(this.getFragmentsFolder());
        if (fragmentsDir.isDirectory() && (xmlFiles = fragmentsDir.listFiles(filter = file -> file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml"))) != null) {
            for (File xmlFile : xmlFiles) {
                this.loadXmlFile(xmlFile.getParent(), xmlFile.getName());
            }
        }
    }

    private void loadXmlFile(String directory, String filename) {
        XmlObject xmlObj = this.xmlLoader.load(directory, filename);
        if (xmlObj instanceof PolicyFragmentDocument) {
            this.loadFromXmlDoc((PolicyFragmentDocument)xmlObj);
        } else {
            LOG.warn((Object)("Unrecognized XML content in " + filename + ". Skipping file."));
        }
    }

    private void loadFromXmlDoc(PolicyFragmentDocument doc) {
        PolicyFragmentConfigType fragmentConfigType = doc.getPolicyFragment();
        try {
            Tree.Node<AuthnSelectionAction> policy = this.buildAuthnSelectionActionNode(fragmentConfigType.getPolicy());
            PolicyFragment fragment = new PolicyFragment(policy);
            fragment.setId(fragmentConfigType.getId());
            fragment.setName(fragmentConfigType.getName());
            fragment.setDescription(fragmentConfigType.getDescription());
            if (StringUtils.isNotBlank((String)fragmentConfigType.getInputContractId())) {
                fragment.setInputContractId(fragmentConfigType.getInputContractId());
            }
            if (StringUtils.isNotBlank((String)fragmentConfigType.getOutputContractId())) {
                fragment.setOutputContractId(fragmentConfigType.getOutputContractId());
            }
            fragment.setLastModifiedMillis(fragmentConfigType.getLastModifiedMillis());
            this.fragmentMap.put(fragment.getId(), fragment);
        }
        catch (AbstractPolicyTreeConfigManager.TreeLoadException e) {
            LOG.error((Object)("Unable to load fragment policy. Skipping. Reason: " + e.getMessage()));
        }
    }

    private String getFragmentsFolder() {
        SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        return sysDirInfo.getDataDirectory() + File.separator + FRAGMENTS_DIR;
    }

    private PolicyFragmentDocument convertToXmlDoc(PolicyFragment fragment) {
        PolicyFragmentDocument doc = PolicyFragmentDocument.Factory.newInstance();
        PolicyFragmentConfigType fragmentConfigType = doc.addNewPolicyFragment();
        fragmentConfigType.setId(fragment.getId());
        fragmentConfigType.setName(fragment.getName());
        if (StringUtils.isNotBlank((String)fragment.getDescription())) {
            fragmentConfigType.setDescription(fragment.getDescription());
        }
        fragmentConfigType.setInputContractId(fragment.getInputContractId());
        fragmentConfigType.setOutputContractId(fragment.getOutputContractId());
        fragmentConfigType.setLastModifiedMillis(System.currentTimeMillis());
        Tree.Node rootNode = fragment.getRootNode();
        AstNodeType xmlAstRootNode = fragmentConfigType.addNewPolicy();
        this.convertAsaNodeToXml((Tree.Node<AuthnSelectionAction>)rootNode, xmlAstRootNode);
        return doc;
    }

    @Override
    public Collection<PolicyFragment> searchFragments(Integer page, Integer numberPerPage, String filter) {
        SearchCriteria searchCriteria2;
        Searchable searchable = searchCriteria -> {
            ContainsCriteriaFilter<PolicyFragment> filter1 = new ContainsCriteriaFilter<PolicyFragment>(c -> new ItemMultiValue<PolicyFragment, String>((PolicyFragment)c, (K[])new String[]{c.getId(), c.getName()}));
            Collection searchResults = filter1.doFilter(searchCriteria.getQuery(), this.getFragments().parallelStream().collect(Collectors.toList()));
            if (searchCriteria.getStartIndex() >= searchResults.size()) {
                return new SearchResult(searchCriteria.getStartIndex(), Collections.emptyList());
            }
            searchResults = searchResults.parallelStream().sorted(COMPARE_BY_NAME_DOWN).collect(Collectors.toList());
            if (searchCriteria.getItemsRequested() == -1) {
                return new SearchResult(0, new ArrayList(searchResults));
            }
            int fromIndex = searchCriteria.getStartIndex();
            int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
            return new SearchResult(searchCriteria.getStartIndex(), new ArrayList(searchResults).subList(fromIndex, toIndex));
        };
        if (page == null) {
            searchCriteria2 = new SearchCriteria.Builder().query(filter).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria2 = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filter).build();
        }
        SearchResult adaptersSearchResult = searchable.search(searchCriteria2);
        return adaptersSearchResult.getResults();
    }

    @Override
    public boolean isFragmentInUse(String fragmentId) {
        return MgmtFactory.getAuthnSelectionConfigManager().isFragmentInUse(fragmentId) || MgmtFactory.getLocalIdentityProfileManager().isFragmentInUse(fragmentId) || this.isFragmentInUseByFragments(fragmentId);
    }

    @Override
    public boolean isFragmentInUseByFragments(String fragmentId) {
        for (PolicyFragment policyFragment : this.getFragments()) {
            if (policyFragment.getId().equals(fragmentId)) continue;
            FragmentSourceKeyVisitor fragmentSourceKeyVisitor = new FragmentSourceKeyVisitor(fragmentId);
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)policyFragment, (TraversalVisitor)fragmentSourceKeyVisitor);
            if (!fragmentSourceKeyVisitor.isMatch()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PolicyFragment> getFragmentsUsingFragment(String fragmentId) {
        LinkedList<PolicyFragment> fragmentsInUse = new LinkedList<PolicyFragment>();
        for (PolicyFragment policyFragment : this.getFragments()) {
            if (policyFragment.getId().equals(fragmentId)) continue;
            FragmentSourceKeyVisitor fragmentSourceKeyVisitor = new FragmentSourceKeyVisitor(fragmentId);
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)policyFragment, (TraversalVisitor)fragmentSourceKeyVisitor);
            if (!fragmentSourceKeyVisitor.isMatch()) continue;
            fragmentsInUse.add(policyFragment);
        }
        return fragmentsInUse;
    }

    @Override
    public List<PolicyFragment> getAllFragmentsUsingFragment(String fragmentId) {
        LinkedList<PolicyFragment> fragmentsInUse = new LinkedList<PolicyFragment>();
        for (PolicyFragment policyFragment : this.getFragments()) {
            FragmentSourceKeyVisitor fragmentSourceKeyVisitor = new FragmentSourceKeyVisitor(fragmentId);
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)policyFragment, (TraversalVisitor)fragmentSourceKeyVisitor);
            if (!fragmentSourceKeyVisitor.isMatch()) continue;
            fragmentsInUse.add(policyFragment);
        }
        return fragmentsInUse;
    }

    @Override
    public boolean isAuthnSourceInUse(AuthnSourceKey authnSourceKey) {
        for (PolicyFragment policyFragment : this.getFragments()) {
            AuthnSourceKeyVisitor authnSourceKeyVisitor = new AuthnSourceKeyVisitor(authnSourceKey);
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)policyFragment, (TraversalVisitor)authnSourceKeyVisitor);
            if (!authnSourceKeyVisitor.isMatch()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PolicyFragment> getFragmentsUsingAuthnSource(AuthnSourceKey authnSourceKey) {
        LinkedList<PolicyFragment> fragmentsInUse = new LinkedList<PolicyFragment>();
        for (PolicyFragment policyFragment : this.getFragments()) {
            AuthnSourceKeyVisitor authnSourceKeyVisitor = new AuthnSourceKeyVisitor(authnSourceKey);
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)policyFragment, (TraversalVisitor)authnSourceKeyVisitor);
            if (!authnSourceKeyVisitor.isMatch()) continue;
            fragmentsInUse.add(policyFragment);
        }
        return fragmentsInUse;
    }

    @Override
    public boolean isPolicyContractInUse(String apcId) {
        for (PolicyFragment policyFragment : this.getFragments()) {
            if (apcId == null || apcId.isEmpty() || !apcId.equals(policyFragment.getOutputContractId()) && !apcId.equals(policyFragment.getInputContractId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PolicyFragment> getFragmentsUsingPolicyContract(String contractId) {
        LinkedList<PolicyFragment> fragmentsInUse = new LinkedList<PolicyFragment>();
        for (PolicyFragment policyFragment : this.getFragments()) {
            if (!StringUtils.equals((String)policyFragment.getOutputContractId(), (String)contractId) && !StringUtils.equals((String)policyFragment.getInputContractId(), (String)contractId)) continue;
            fragmentsInUse.add(policyFragment);
        }
        return fragmentsInUse;
    }

    @Override
    public List<PolicyFragment> getFragmentsUsingInputPolicyContract(String contractId) {
        LinkedList<PolicyFragment> fragmentsInUse = new LinkedList<PolicyFragment>();
        for (PolicyFragment policyFragment : this.getFragments()) {
            if (!StringUtils.equals((String)policyFragment.getInputContractId(), (String)contractId)) continue;
            fragmentsInUse.add(policyFragment);
        }
        return fragmentsInUse;
    }

    @Override
    public List<PolicyFragment> getFragmentsUsingOutputPolicyContract(String contractId) {
        LinkedList<PolicyFragment> fragmentsInUse = new LinkedList<PolicyFragment>();
        for (PolicyFragment policyFragment : this.getFragments()) {
            if (!StringUtils.equals((String)policyFragment.getOutputContractId(), (String)contractId)) continue;
            fragmentsInUse.add(policyFragment);
        }
        return fragmentsInUse;
    }

    @Override
    public boolean isLocalIdentityProfileInUse(String lipId) {
        PolicyFragmentManager policyFragmentManager = MgmtFactory.getPolicyFragmentManager();
        for (PolicyFragment policyFragment : policyFragmentManager.getFragments()) {
            LeafNodeVisitor leafNodeVisitor = new LeafNodeVisitor();
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)policyFragment, (TraversalVisitor)leafNodeVisitor);
            for (Tree.Node<AuthnSelectionAction> node : leafNodeVisitor.getLipNodes()) {
                LocalIdentityMappingAction lipAction = (LocalIdentityMappingAction)node.getData();
                if (!lipId.equals(lipAction.getLipId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<PolicyFragment> getFragmentsUsingLocalIdentity(String lipId) {
        LinkedList<PolicyFragment> fragmentsInUse = new LinkedList<PolicyFragment>();
        for (PolicyFragment policyFragment : this.getFragments()) {
            LeafNodeVisitor leafNodeVisitor = new LeafNodeVisitor();
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)policyFragment, (TraversalVisitor)leafNodeVisitor);
            for (Tree.Node<AuthnSelectionAction> node : leafNodeVisitor.getLipNodes()) {
                LocalIdentityMappingAction lipAction = (LocalIdentityMappingAction)node.getData();
                if (!lipId.equals(lipAction.getLipId())) continue;
                fragmentsInUse.add(policyFragment);
            }
        }
        return fragmentsInUse;
    }

    @Override
    public boolean isDataSourceInUse(String dataSourceId) {
        for (PolicyFragment policyFragment : this.getFragments()) {
            if (!this.isDataSourceInUseByFragment(dataSourceId, policyFragment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PolicyFragment> getFragmentsUsingDataSource(String dataSourceId) {
        LinkedList<PolicyFragment> fragmentsInUse = new LinkedList<PolicyFragment>();
        for (PolicyFragment policyFragment : this.getFragments()) {
            if (!this.isDataSourceInUseByFragment(dataSourceId, policyFragment)) continue;
            fragmentsInUse.add(policyFragment);
        }
        return fragmentsInUse;
    }

    private boolean isDataSourceInUseByFragment(String dataSourceId, PolicyFragment policyFragment) {
        LinkedBlockingQueue<Tree.Node> queue = new LinkedBlockingQueue<Tree.Node>();
        Tree.Node root = policyFragment.getRootNode();
        if (this.isDataSourceInUseByNode((Tree.Node<AuthnSelectionAction>)root, dataSourceId)) {
            return true;
        }
        queue.add(root);
        while (!queue.isEmpty()) {
            Tree.Node currentNode = (Tree.Node)queue.remove();
            if (this.isDataSourceInUseByNode((Tree.Node<AuthnSelectionAction>)currentNode, dataSourceId)) {
                return true;
            }
            if (!(currentNode.getData() instanceof AuthnSourceAction) && !(currentNode.getData() instanceof AuthnSelectorAction) && !(currentNode.getData() instanceof FragmentAction)) continue;
            for (Tree.Node node : currentNode.getChildren()) {
                queue.add(node);
            }
        }
        return false;
    }

    private boolean isDataSourceInUseByNode(Tree.Node<AuthnSelectionAction> node, String dataSourceId) {
        return node.getData() instanceof ApcMappingAction && InUseDetectionUtil.getInstance().isDataSourceInUseByAttributeMapping(((ApcMappingAction)node.getData()).getAttributeMapping(), dataSourceId) || node.getData() instanceof FragmentAction && InUseDetectionUtil.getInstance().isDataSourceInUseByAttributeMapping(((FragmentAction)node.getData()).getAttributeMapping(), dataSourceId) || node.getData() instanceof LocalIdentityMappingAction && InUseDetectionUtil.getInstance().isDataSourceInUseByAttributeMapping(((LocalIdentityMappingAction)node.getData()).getAttributeMapping(), dataSourceId);
    }

    @Override
    public boolean isAuthnSelectorInUse(String authnSelectorId) {
        AuthnSelectorVisitor authnSelectorVisitor = new AuthnSelectorVisitor(authnSelectorId);
        for (PolicyFragment fragment : this.getFragments()) {
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)fragment, (TraversalVisitor)authnSelectorVisitor);
            if (!authnSelectorVisitor.isMatch()) continue;
            return true;
        }
        return false;
    }
}

