/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.c2ccontract.mgmt.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.x2014.x10.c2CContracts.AttributeType;
import com.pingidentity.x2014.x10.c2CContracts.AttributesType;
import com.pingidentity.x2014.x10.c2CContracts.C2CContractDocument;
import com.pingidentity.x2014.x10.c2CContracts.C2CContractType;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.Searchable;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;

public class C2cContractManagerImpl
implements C2cContractManager,
AutoReloadable {
    private static final Log LOG = LogFactory.getLog(C2cContractManagerImpl.class);
    private static final String CONFIG_FILE_EXT = ".xml";
    private static final String CONTRACTS_DIR = "connection-mapping-contracts";
    private final Map<String, C2cContract> contracts = new HashMap<String, C2cContract>();
    private final Set<String> contractNames = new HashSet<String>();
    private final XmlLoader xmlLoader;
    private static final Comparator<C2cContract> COMPARE_BY_NAME_DOWN = (contract1, contract2) -> contract1.getName().compareToIgnoreCase(contract2.getName());

    public C2cContractManagerImpl(XmlLoader xmlLoader) {
        this.xmlLoader = xmlLoader;
        this.loadConfig();
    }

    @Override
    public synchronized Collection<C2cContract> getContracts() {
        return new ArrayList<C2cContract>(this.contracts.values());
    }

    @Override
    public synchronized C2cContract getContract(String id) {
        return this.contracts.get(id);
    }

    @Override
    public synchronized C2cContract saveContract(C2cContract contract) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            boolean isUpdate;
            if (contract.getId() == null) {
                contract.setId(IDGenerator.rndAlphaNumeric(16));
                isUpdate = false;
            } else {
                isUpdate = this.doDeleteContract(contract.getId());
            }
            contract.setLastModified((Calendar)new XmlCalendar(new Date()));
            C2CContractDocument doc = this.convertToXmlDoc(contract);
            this.xmlLoader.save(this.getContractsPath(), contract.getId() + CONFIG_FILE_EXT, (XmlObject)doc);
            auditLoggerScope.log(AdminAuditLogger.Component.CONTRACT_CONN_MAPPING, isUpdate ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE, contract.getName());
        }
        this.contracts.put(contract.getId(), contract);
        this.contractNames.add(contract.getName().toLowerCase(Locale.ENGLISH));
        return contract;
    }

    @Override
    public synchronized void deleteContract(String id) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            C2cContract existing = this.contracts.get(id);
            this.doDeleteContract(id);
            auditLoggerScope.log(AdminAuditLogger.Component.CONTRACT_CONN_MAPPING, AdminAuditLogger.Event.DELETE, existing != null ? existing.getName() : "");
        }
    }

    private synchronized boolean doDeleteContract(String id) {
        this.xmlLoader.delete(this.getContractsPath(), id + CONFIG_FILE_EXT);
        C2cContract contract = this.contracts.remove(id);
        if (contract != null) {
            this.contractNames.remove(contract.getName().toLowerCase(Locale.ENGLISH));
        }
        return contract != null;
    }

    private synchronized void loadConfig() {
        FileFilter filter;
        File[] xmlFiles;
        this.contracts.clear();
        this.contractNames.clear();
        File contractsDir = new File(this.getContractsPath());
        if (contractsDir.isDirectory() && (xmlFiles = contractsDir.listFiles(filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(C2cContractManagerImpl.CONFIG_FILE_EXT);
            }
        })) != null) {
            for (File xmlFile : xmlFiles) {
                XmlObject xmlObj = this.xmlLoader.load(xmlFile.getParent(), xmlFile.getName());
                if (xmlObj instanceof C2CContractDocument) {
                    this.loadFromXmlDoc((C2CContractDocument)xmlObj);
                    continue;
                }
                LOG.warn((Object)("Unrecognized XML content in " + xmlFile.getAbsolutePath() + ". Skipping file."));
            }
        }
    }

    private String getContractsPath() {
        SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        return sysDirInfo.getDataDirectory() + File.separator + CONTRACTS_DIR;
    }

    private void loadFromXmlDoc(C2CContractDocument doc) {
        C2CContractType cmcType = doc.getC2CContract();
        C2cContract contract = new C2cContract();
        contract.setId(cmcType.getId());
        contract.setName(cmcType.getName());
        AttributesType attrsType = cmcType.getExtendedAttributes();
        if (attrsType != null) {
            for (AttributeType attrType : attrsType.getAttrArray()) {
                contract.addMutableAttributeName(attrType.getName());
            }
        }
        if (this.contracts.put(contract.getId(), contract) != null) {
            LOG.warn((Object)("A duplicate Authentication Policy Contract was loaded with ID '" + contract.getId() + "'. Overwriting previous contract."));
        }
        this.contractNames.add(contract.getName().toLowerCase(Locale.ENGLISH));
    }

    private C2CContractDocument convertToXmlDoc(C2cContract contract) {
        C2CContractDocument doc = C2CContractDocument.Factory.newInstance();
        C2CContractType cmcType = doc.addNewC2CContract();
        cmcType.setId(contract.getId());
        cmcType.setName(contract.getName());
        cmcType.setLastModified(contract.getLastModified());
        AttributesType attrTypes = cmcType.addNewExtendedAttributes();
        if (!contract.getMutableAttributeNames().isEmpty()) {
            for (String mutableAttrName : contract.getMutableAttributeNames()) {
                AttributeType attrType = attrTypes.addNewAttr();
                attrType.setName(mutableAttrName);
            }
        }
        cmcType.setExtendedAttributes(attrTypes);
        return doc;
    }

    @Override
    public boolean isContractNameInUse(String id, String name) {
        String existingName;
        C2cContract existingContract;
        if (id != null && (existingContract = this.contracts.get(id)) != null && (existingName = existingContract.getName()) != null && existingName.equalsIgnoreCase(name)) {
            return false;
        }
        return this.contractNames.contains(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isContractInUse(String contractId) {
        if (MgmtFactory.getAuthnSelectionConfigManager().isPolicyContractInUse(contractId)) {
            return true;
        }
        if (MgmtFactory.getPolicyFragmentManager().isPolicyContractInUse(contractId)) {
            return true;
        }
        if (MgmtFactory.getApc2SpAdapterManager().isSourceInUse(contractId)) {
            return true;
        }
        if (MgmtFactory.getAuthzServerManager().isApcInUse(contractId)) {
            return true;
        }
        if (MgmtFactory.getLocalIdentityProfileManager().isApcInUse(contractId)) {
            return true;
        }
        ConnectionManager connMgr = MgmtFactory.getConnectionManager();
        for (IdpConnection idpConn : connMgr.getAllIdpConnections()) {
            for (C2cContractAttributeMapping c2cContractAttributeMapping : idpConn.getC2cContractMappings()) {
                if (!contractId.equals(c2cContractAttributeMapping.getContractId())) continue;
                return true;
            }
        }
        for (SpConnection spConn : connMgr.getAllSpConnections()) {
            for (C2cContractToAssertionMapping c2cContractToAssertionMapping : spConn.getC2cMappings()) {
                if (!contractId.equals(c2cContractToAssertionMapping.getContractId())) continue;
                return true;
            }
        }
        List<IdpAuthnAdapterInstance> idpAdaptersWithPolicyInUse = InUseDetectionUtil.getInstance().getIdpAdaptersWithApcInUse(contractId);
        return !idpAdaptersWithPolicyInUse.isEmpty();
    }

    @Override
    public String findMappedContractId(IdpConnection idpConn, String spConnEntityId) {
        ConnectionManager connMgr = MgmtFactory.getConnectionManager();
        SpConnection spConn = connMgr.getSpConnection(spConnEntityId);
        if (spConn == null) {
            return null;
        }
        return this.findMappedContractId(idpConn, spConn);
    }

    @Override
    public String findMappedContractId(SpConnection spConn, String idpConnId) {
        ConnectionManager connMgr = MgmtFactory.getConnectionManager();
        IdpConnection idpConn = connMgr.getIdpConnectionBySystemId(idpConnId);
        if (idpConn == null) {
            return null;
        }
        return this.findMappedContractId(idpConn, spConn);
    }

    private String findMappedContractId(IdpConnection idpConn, SpConnection spConn) {
        HashSet<String> idpMappedContracts = new HashSet<String>();
        HashSet<String> spMappedContracts = new HashSet<String>();
        for (C2cContractAttributeMapping c2cContractAttributeMapping : idpConn.getC2cContractMappings()) {
            idpMappedContracts.add(c2cContractAttributeMapping.getContractId());
        }
        for (C2cContractToAssertionMapping c2cContractToAssertionMapping : spConn.getC2cMappings()) {
            spMappedContracts.add(c2cContractToAssertionMapping.getContractId());
        }
        idpMappedContracts.retainAll(spMappedContracts);
        if (idpMappedContracts.size() == 0) {
            return null;
        }
        if (idpMappedContracts.size() == 1) {
            return (String)idpMappedContracts.iterator().next();
        }
        String msg = "Idp connection (" + idpConn.getEntityId() + ") is mapped to Sp connection (" + spConn.getEntityId() + ") through multiple Authentication Policy Contracts. Choosing random contract.";
        LOG.warn((Object)msg);
        return (String)idpMappedContracts.iterator().next();
    }

    @Override
    public Collection<C2cContract> searchAuthenticationPolicyContracts(Integer page, Integer numberPerPage, String filter) {
        SearchCriteria searchCriteria;
        Searchable<C2cContract> searchable = new Searchable<C2cContract>(){

            @Override
            public SearchResult<C2cContract> search(SearchCriteria searchCriteria) {
                ContainsCriteriaFilter<C2cContract> filter = new ContainsCriteriaFilter<C2cContract>(c -> new ItemMultiValue<C2cContract, String>((C2cContract)c, (K[])new String[]{c.getId(), c.getName()}));
                Collection searchResults = filter.doFilter(searchCriteria.getQuery(), C2cContractManagerImpl.this.getContracts().parallelStream().collect(Collectors.toList()));
                if (searchCriteria.getStartIndex() >= searchResults.size()) {
                    return new SearchResult<C2cContract>(searchCriteria.getStartIndex(), Collections.emptyList());
                }
                searchResults = searchResults.parallelStream().sorted(COMPARE_BY_NAME_DOWN).collect(Collectors.toList());
                if (searchCriteria.getItemsRequested() == -1) {
                    return new SearchResult<C2cContract>(0, new ArrayList(searchResults));
                }
                int fromIndex = searchCriteria.getStartIndex();
                int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
                return new SearchResult<C2cContract>(searchCriteria.getStartIndex(), new ArrayList(searchResults).subList(fromIndex, toIndex));
            }
        };
        if (page == null) {
            searchCriteria = new SearchCriteria.Builder().query(filter).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filter).build();
        }
        SearchResult apcSearchResult = searchable.search(searchCriteria);
        return apcSearchResult.getResults();
    }
}

