/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.captcha.util;

import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.RegistrationConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.CaptchaProviderFieldDescriptor;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class CaptchaProviderUtil {
    private CaptchaProviderUtil() {
    }

    public static boolean isLipUsingCaptchaProvider(LocalIdentityProfile lip, String captchaProviderId) {
        RegistrationConfig registrationConfig = lip.getRegistrationConfig();
        if (registrationConfig != null && registrationConfig.isCaptchaEnabled()) {
            String lipCaptchaProviderId = registrationConfig.getCaptchaProviderId();
            return StringUtils.isNotBlank((String)lipCaptchaProviderId) && lipCaptchaProviderId.equals(captchaProviderId) || CaptchaProviderUtil.isUsingDefaultCaptchaProvider(lipCaptchaProviderId, captchaProviderId);
        }
        return false;
    }

    public static boolean isAdapterUsingCaptchaProvider(IdpAuthnAdapterInstance idpAdapterInstance, String captchaProviderId) {
        Configuration configuration = idpAdapterInstance.getConfiguration();
        if (configuration != null) {
            String adapterCaptchaProviderId = configuration.getFieldValue("CAPTCHA Provider");
            String riskProviderId = configuration.getFieldValue("Risk Provider");
            boolean isRiskProviderEnabled = configuration.getBooleanFieldValue("Enable Risk Provider");
            if (StringUtils.isNotBlank((String)adapterCaptchaProviderId) && adapterCaptchaProviderId.equals(captchaProviderId) || StringUtils.isNotBlank((String)riskProviderId) && riskProviderId.equals(captchaProviderId)) {
                return true;
            }
            if (configuration.getBooleanFieldValue("CAPTCHA for Authentication") || configuration.getBooleanFieldValue("CAPTCHA for Username recovery") || configuration.getBooleanFieldValue("CAPTCHA for Password Reset") || configuration.getBooleanFieldValue("CAPTCHA for Password change")) {
                return CaptchaProviderUtil.isUsingDefaultCaptchaProvider(adapterCaptchaProviderId, captchaProviderId);
            }
            return isRiskProviderEnabled && CaptchaProviderUtil.isUsingDefaultCaptchaProvider(riskProviderId, captchaProviderId);
        }
        return false;
    }

    public static Map<String, Object> filterInParameters(Map<String, Object> inParameters) {
        return CaptchaProviderUtil.filterInParameters(inParameters, null);
    }

    public static Map<String, Object> filterInParameters(Map<String, Object> inParameters, String userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("com.pingidentity.adapter.input.parameter.tracking.id", inParameters.get("com.pingidentity.adapter.input.parameter.tracking.id"));
        result.put("com.pingidentity.adapter.input.parameter.request.id", inParameters.get("com.pingidentity.adapter.input.parameter.request.id"));
        result.put("com.pingidentity.adapter.input.parameter.transaction.id", inParameters.get("com.pingidentity.adapter.input.parameter.tracking.id"));
        if (StringUtils.isNotBlank((String)userId)) {
            result.put("com.pingidentity.adapter.input.parameter.userid", userId);
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.userid.authenticated")) {
            result.put("com.pingidentity.adapter.input.parameter.userid.authenticated", inParameters.get("com.pingidentity.adapter.input.parameter.userid.authenticated"));
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.partner.entityid")) {
            result.put("com.pingidentity.adapter.input.parameter.partner.entityid", inParameters.get("com.pingidentity.adapter.input.parameter.partner.entityid"));
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.oauth.client.id")) {
            result.put("com.pingidentity.adapter.input.parameter.oauth.client.id", inParameters.get("com.pingidentity.adapter.input.parameter.oauth.client.id"));
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.sp.adapter.id")) {
            result.put("com.pingidentity.adapter.input.parameter.sp.adapter.id", inParameters.get("com.pingidentity.adapter.input.parameter.sp.adapter.id"));
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.chained.attributes")) {
            result.put("com.pingidentity.adapter.input.parameter.chained.attributes", inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes"));
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.device.sharing.type")) {
            result.put("com.pingidentity.adapter.input.parameter.device.sharing.type", inParameters.get("com.pingidentity.adapter.input.parameter.device.sharing.type"));
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.resume.path")) {
            result.put("com.pingidentity.adapter.input.parameter.resume.path", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.application.name")) {
            result.put("com.pingidentity.adapter.input.parameter.application.name", inParameters.get("com.pingidentity.adapter.input.parameter.application.name"));
        }
        if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.application.icon.url")) {
            result.put("com.pingidentity.adapter.input.parameter.application.icon.url", inParameters.get("com.pingidentity.adapter.input.parameter.application.icon.url"));
        }
        return result;
    }

    private static boolean isUsingDefaultCaptchaProvider(String configuredCaptchaProviderId, String captchaProviderId) {
        return (StringUtils.isBlank((String)configuredCaptchaProviderId) || CaptchaProviderFieldDescriptor.DEFAULT.getValue().equals(configuredCaptchaProviderId)) && StringUtils.equals((String)CaptchaProviderUtil.getDefaultCaptchaProviderId(), (String)captchaProviderId);
    }

    private static String getDefaultCaptchaProviderId() {
        CaptchaProviderInstance defaultInstance = (CaptchaProviderInstance)MgmtFactory.getCaptchaProviderPluginManager().getDefaultInstance();
        return defaultInstance != null ? defaultInstance.getId() : null;
    }
}

