/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.event;

import com.pingidentity.common.event.Event;
import com.pingidentity.common.event.EventListener;
import com.pingidentity.common.event.EventProcessor;
import com.pingidentity.common.event.EventType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EventService {
    private BlockingQueue<Runnable> events = null;
    private static EventService instance = new EventService();
    private ExecutorService executorService = null;
    private Map<EventType, List<EventListener>> listeners = new HashMap<EventType, List<EventListener>>();

    private EventService() {
        this.events = new LinkedBlockingQueue<Runnable>();
        this.executorService = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, this.events);
    }

    public static EventService getService() {
        return instance;
    }

    public void addEvent(Event newEvent) {
        EventProcessor eventProcessor = new EventProcessor(newEvent);
        this.executorService.submit(eventProcessor);
    }

    public synchronized void registerEventListener(EventType eventType, EventListener pfEventListener) {
        if (pfEventListener == null) {
            return;
        }
        List<EventListener> eventListeners = this.listeners.get((Object)eventType);
        if (eventListeners == null) {
            eventListeners = new ArrayList<EventListener>();
        }
        boolean listenerExists = false;
        for (EventListener existingListener : eventListeners) {
            if (!existingListener.equals(pfEventListener)) continue;
            listenerExists = true;
            break;
        }
        if (!listenerExists) {
            eventListeners.add(pfEventListener);
            this.listeners.put(eventType, eventListeners);
        }
    }

    public synchronized List<EventListener> getListenersForEvent(EventType eventType) {
        if (this.listeners.get((Object)eventType) != null) {
            return new ArrayList<EventListener>((Collection)this.listeners.get((Object)eventType));
        }
        return new ArrayList<EventListener>();
    }
}

