/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.mgr.impl;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import com.pingidentity.common.mgr.HttpUtilities;
import com.pingidentity.configservice.AutoReloadable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;

public class HttpUtilitiesImpl
implements HttpUtilities,
AutoReloadable {
    private static final String GLOBAL_COOKIE_CONFIG = "global-cookie-config";
    private static final String ENABLE_PARTITIONED_COOKIES = "enable-partitioned-cookies";
    private static final boolean ENABLE_PARTITIONED_COOKIES_DEFAULT = false;
    private static final String PARTITIONED_COOKIES_USER_AGENT_EXCLUSION = "partitioned-cookies-user-agent-exclusion";
    private static final List<String> PARTITIONED_COOKIES_USER_AGENT_EXCLUSION_DEFAULTS = Collections.emptyList();
    private final boolean enablePartitionedCookies;
    private final List<Pattern> partitionedCookiesUserAgentExclusions;

    public HttpUtilitiesImpl() {
        ConfigStore config = ConfigStoreFarm.getConfig(GLOBAL_COOKIE_CONFIG);
        this.enablePartitionedCookies = config.getBooleanValue(ENABLE_PARTITIONED_COOKIES, false);
        this.partitionedCookiesUserAgentExclusions = config.getListValue(PARTITIONED_COOKIES_USER_AGENT_EXCLUSION, PARTITIONED_COOKIES_USER_AGENT_EXCLUSION_DEFAULTS).stream().map(Pattern::compile).collect(Collectors.toList());
    }

    @Override
    public void addPartitionedAttributeToCookie(Cookie cookie) {
        if (!this.enablePartitionedCookies) {
            return;
        }
        String userAgent = HttpRequestLoggingUtil.getHttpHeaderValue("User-Agent");
        if (StringUtils.isNotBlank((CharSequence)userAgent)) {
            for (Pattern pattern : this.partitionedCookiesUserAgentExclusions) {
                Matcher userAgentMatcher = pattern.matcher((CharSequence)userAgent);
                if (!userAgentMatcher.find()) continue;
                return;
            }
        }
        String cookieComment = StringUtils.isNotBlank((CharSequence)cookie.getComment()) ? cookie.getComment() + "__PARTITIONED__" : "__PARTITIONED__";
        cookie.setComment(cookieComment);
    }
}

