/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.security;

import com.pingidentity.common.security.LockingService;
import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.Cache;
import com.pingidentity.common.util.DistributableCache;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.state.ConsistentHashTracker;
import org.sourceid.saml20.state.StateMgmtFactory;

public class AccountLockingService
implements LockingService {
    public static final int DEFAULT_MAX_CONSECUTIVE_FAILURES = 3;
    public static final int DEFAULT_MAX_PASSWORD_ATTEMPTS = 5;
    public static final int DEFAULT_MAX_MALICIOUS_ACTIONS = 5;
    public static final int MAX_MALICIOUS_ACTIONS_DISABLED = -1;
    public static final int DEFAULT_LOCKOUT_PERIOD = 1;
    public static final int DEFAULT_PASSWORD_LOCKOUT_PERIOD = 5;
    public static final boolean DEFAULT_DO_PASSWORD_LOCKING = false;
    public static final boolean DEFAULT_USE_IP_FOR_LOCKOUT = true;
    public static final int FAILURE_MAP_MAX_SIZE = 10000;
    public static final int MALICIOUS_MAP_MAX_SIZE = 1000;
    private static final String MAX_CONSECUTIVE_FAILURES = "MaxConsecutiveFailures";
    private static final String MAX_PASSWORD_ATTEMPTS = "MaxPasswordAttempts";
    private static final String MAX_MALICIOUS_ACTIONS = "MaxMaliciousActions";
    private static final String LOCKOUT_PERIOD = "LockoutPeriod";
    private static final String PASSWORD_LOCKOUT_PERIOD = "PasswordLockoutPeriod";
    private static final String DO_PASSWORD_LOCKING = "DoPasswordLocking";
    private static final String USE_IP_FOR_LOCKOUT = "UseIPForLockout";
    private static final Log log = LogFactory.getLog(AccountLockingService.class);
    private static final Map<String, AccountLockingService> instances = Collections.synchronizedMap(new HashMap());
    private static final int MAX_KEY_LENGTH = 100;
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(null, r, "AccountLockingService Cleanup Thread");
        t.setDaemon(true);
        return t;
    });
    private final DistributableCache<AccountLockingState> failureMap;
    private final DistributableCache<AccountLockingState> maliciousActionsMap;
    private final ClientManager clientManager;

    public static AccountLockingService forName(String name) {
        return AccountLockingService.forName(name, StateMgmtFactory.makeConsistentHashTracker(true, true));
    }

    public static AccountLockingService forName(String name, ConsistentHashTracker tracker) {
        return AccountLockingService.forName(name, tracker, MgmtFactory.getClientManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountLockingService forName(String name, ConsistentHashTracker tracker, ClientManager clientManager) {
        Map<String, AccountLockingService> map = instances;
        synchronized (map) {
            if (!instances.containsKey(name)) {
                instances.put(name, new AccountLockingService(tracker, clientManager));
            }
            return instances.get(name);
        }
    }

    AccountLockingService(ClientManager clientManager) {
        this(StateMgmtFactory.makeConsistentHashTracker(true, true), clientManager);
    }

    AccountLockingService(ConsistentHashTracker tracker, ClientManager clientManager) {
        this.failureMap = new DistributableCache(-1L, 10000, true, tracker);
        this.maliciousActionsMap = new DistributableCache(-1L, 1000, true, tracker);
        this.clientManager = clientManager;
    }

    private synchronized int getFailureMapSize() {
        return this.failureMap.size();
    }

    private synchronized int getMaliciousActionsMapSize() {
        return this.maliciousActionsMap.size();
    }

    @Override
    public synchronized void logFailedLogin(String key) {
        this.logFailure(this.failureMap, key);
    }

    @Override
    public synchronized void logFailedPassword(String key) {
        if (AccountLockingService.doPasswordLocking()) {
            this.logFailure(this.failureMap, key);
        }
    }

    @Override
    public synchronized void logMaliciousAction(String key) {
        this.logFailure(this.maliciousActionsMap, key);
    }

    private synchronized void logFailure(Map<String, AccountLockingState> map, String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        String lowerCaseKey = AccountLockingService.normalizeKey(key);
        long currentTimeMillis = this.getCurrentTimeMillis();
        if (map.containsKey(lowerCaseKey)) {
            AccountLockingState failureState = map.get(lowerCaseKey);
            failureState.addFailure(currentTimeMillis);
        } else {
            AccountLockingState failureState = new AccountLockingState();
            failureState.addFailure(currentTimeMillis);
            map.put(lowerCaseKey, failureState);
        }
    }

    @Override
    public synchronized boolean isLocked(String key) {
        return this.isLocked(key, AccountLockingService.getMaxConsecutiveFailures(), AccountLockingService.getLockoutPeriod());
    }

    @Override
    public synchronized boolean isLockedWithMaxMaliciousActions(String key) {
        return this.isLocked(key, AccountLockingService.getMaxConsecutiveFailures(), this.getMaxMaliciousActions(key), AccountLockingService.getLockoutPeriod());
    }

    @Override
    public synchronized boolean isLocked(String key, int maxFailedLogins, int lockoutPeriod) {
        return this.isLocked(key, maxFailedLogins, AccountLockingService.getMaxMaliciousActions(), lockoutPeriod);
    }

    @Override
    public boolean isLocked(LockingService.IsLockedRequest request) {
        int lockoutPeriod;
        int maxFailedLogins;
        if (request.getLoginType() == LockingService.FailedLoginType.PASSWORD && !AccountLockingService.doPasswordLocking()) {
            return false;
        }
        if (request.isUseDefaultLimits()) {
            if (request.getLoginType() == LockingService.FailedLoginType.PASSWORD) {
                maxFailedLogins = AccountLockingService.getMaxPasswordAttempts();
                lockoutPeriod = AccountLockingService.getPasswordLockoutPeriod();
            } else {
                maxFailedLogins = AccountLockingService.getMaxConsecutiveFailures();
                lockoutPeriod = AccountLockingService.getLockoutPeriod();
            }
        } else {
            maxFailedLogins = request.getMaxFailedLogins();
            lockoutPeriod = request.getLockoutPeriod();
        }
        return this.isLocked(request.getKey(), maxFailedLogins, AccountLockingService.getMaxMaliciousActions(), lockoutPeriod);
    }

    public synchronized boolean isLocked(String key, int maxFailedLogins, int maxMaliciousActions, int lockoutPeriod) {
        boolean isLocked = false;
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        String lowerCaseKey = AccountLockingService.normalizeKey(key);
        if (this.failureMap.containsKey(lowerCaseKey)) {
            AccountLockingState failureState = (AccountLockingState)this.failureMap.get(lowerCaseKey);
            isLocked = this.checkLockingState(failureState, lockoutPeriod, maxFailedLogins);
        } else if (maxMaliciousActions != -1 && this.maliciousActionsMap.containsKey(lowerCaseKey)) {
            AccountLockingState failureState = (AccountLockingState)this.maliciousActionsMap.get(lowerCaseKey);
            isLocked = this.checkLockingState(failureState, lockoutPeriod, maxMaliciousActions);
        }
        return isLocked;
    }

    private boolean checkLockingState(AccountLockingState failureState, int lockoutPeriod, int maxConsecutiveFailures) {
        boolean isLocked = false;
        long currentTimeMillis = this.getCurrentTimeMillis();
        long lockoutPeriodMillis = (long)lockoutPeriod * 60L * 1000L;
        failureState.setLockoutPeriod(lockoutPeriod);
        failureState.deleteFailuresOlderThan(currentTimeMillis - lockoutPeriodMillis);
        if (failureState.getLockExpiry() > currentTimeMillis) {
            isLocked = true;
        } else if (failureState.getFailureCount() >= maxConsecutiveFailures) {
            failureState.setLockExpiry(currentTimeMillis + lockoutPeriodMillis);
            isLocked = true;
        }
        return isLocked;
    }

    @Override
    public synchronized void clearFailedLogins(String key) {
        if (this.clearFailure(this.failureMap, key) && log.isDebugEnabled()) {
            log.debug((Object)("cleared failed logins for " + key));
        }
    }

    @Override
    public synchronized void clearMaliciousActions(String key) {
        if (this.clearFailure(this.maliciousActionsMap, key) && log.isDebugEnabled()) {
            log.debug((Object)("cleared malicious actions for " + key));
        }
    }

    private synchronized boolean clearFailure(Map<String, AccountLockingState> map, String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return map.remove(AccountLockingService.normalizeKey(key)) != null;
    }

    public static int getMaxPasswordAttempts() {
        return ConfigStoreFarm.getConfig(AccountLockingService.class).getIntValue(MAX_PASSWORD_ATTEMPTS, 5);
    }

    public static int getMaxConsecutiveFailures() {
        return ConfigStoreFarm.getConfig(AccountLockingService.class).getIntValue(MAX_CONSECUTIVE_FAILURES, 3);
    }

    public static int getMaxMaliciousActions() {
        return ConfigStoreFarm.getConfig(AccountLockingService.class).getIntValue(MAX_MALICIOUS_ACTIONS, 5);
    }

    private int getMaxMaliciousActions(String key) {
        String clientId;
        Client client;
        if (key != null && key.contains("_") && (client = this.clientManager.getCachedClient(clientId = key.substring(key.indexOf(95) + 1))) != null) {
            if ("OVERRIDE_SERVER_DEFAULT".equals(client.getLockoutMaxMaliciousActionsType())) {
                return client.getLockoutMaxMaliciousActions();
            }
            if ("DO_NOT_LOCKOUT".equals(client.getLockoutMaxMaliciousActionsType())) {
                return -1;
            }
        }
        return ConfigStoreFarm.getConfig(AccountLockingService.class).getIntValue(MAX_MALICIOUS_ACTIONS, 5);
    }

    public static int getLockoutPeriod() {
        return ConfigStoreFarm.getConfig(AccountLockingService.class).getIntValue(LOCKOUT_PERIOD, 1);
    }

    public static int getPasswordLockoutPeriod() {
        return ConfigStoreFarm.getConfig(AccountLockingService.class).getIntValue(PASSWORD_LOCKOUT_PERIOD, 5);
    }

    public static boolean doPasswordLocking() {
        return ConfigStoreFarm.getConfig(AccountLockingService.class).getBooleanValue(DO_PASSWORD_LOCKING, false);
    }

    private static boolean useIpForLockout() {
        return ConfigStoreFarm.getConfig(AccountLockingService.class).getBooleanValue(USE_IP_FOR_LOCKOUT, true);
    }

    public static String getUserKey(String ipAddress, String username) {
        return AccountLockingService.useIpForLockout() ? ipAddress + username : username;
    }

    public static String getUserKeyWithMaxMaliciousActions(String ipAddress, String username) {
        return AccountLockingService.useIpForLockout() ? ipAddress + "_" + username : "_" + username;
    }

    long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static void importRecords(Collection<AccountLockingEntry> entries) {
        for (AccountLockingEntry entry : entries) {
            AccountLockingState state = entry.getState();
            if (state.getFailureCount() <= 0) continue;
            AccountLockingService instance = AccountLockingService.forName(entry.getInstanceName());
            instance.addStateToMap(entry, entry.isFailure());
        }
    }

    private synchronized void addStateToMap(AccountLockingEntry entry, boolean isFailure) {
        DistributableCache<AccountLockingState> map = isFailure ? this.failureMap : this.maliciousActionsMap;
        map.tryPutWithTimestamp(entry.getKey(), entry.getState(), entry.getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AccountLockingEntry> getRecords(int startHash, int endHashExclusive) {
        Map<String, AccountLockingService> map = instances;
        synchronized (map) {
            ArrayList<AccountLockingEntry> result = new ArrayList<AccountLockingEntry>();
            for (Map.Entry<String, AccountLockingService> entry : instances.entrySet()) {
                String instanceName = entry.getKey();
                AccountLockingService instance = entry.getValue();
                result.addAll(instance.getAccountLockingEntries(startHash, endHashExclusive, true, instanceName));
                result.addAll(instance.getAccountLockingEntries(startHash, endHashExclusive, false, instanceName));
            }
            return result;
        }
    }

    private synchronized Collection<AccountLockingEntry> getAccountLockingEntries(int startHash, int endHashExclusive, boolean isFailure, String instanceName) {
        ArrayList<AccountLockingEntry> entries = new ArrayList<AccountLockingEntry>();
        DistributableCache<AccountLockingState> map = isFailure ? this.failureMap : this.maliciousActionsMap;
        Collection<Cache.Entry<String, AccountLockingState>> rangeEntries = map.getEntriesForRange(startHash, endHashExclusive);
        for (Cache.Entry<String, AccountLockingState> rangeEntry : rangeEntries) {
            AccountLockingState state = rangeEntry.getValue();
            if (state == null) continue;
            long lockoutPeriodMillis = (long)state.getLockoutPeriod() * 60L * 1000L;
            long currentTime = System.currentTimeMillis();
            state.deleteFailuresOlderThan(currentTime - lockoutPeriodMillis);
            if (state.getFailureCount() <= 0) continue;
            AccountLockingEntry entry = new AccountLockingEntry(instanceName, rangeEntry.getKey(), new AccountLockingState(state), rangeEntry.getTimestamp(), isFailure);
            entries.add(entry);
        }
        return entries;
    }

    private synchronized void purge(int startHash, int endHashExclusive) {
        Collection<String> failureKeys = this.failureMap.getKeysForRange(startHash, endHashExclusive);
        for (String key : failureKeys) {
            this.clearFailedLogins(key);
        }
        Collection<String> maliciousActionsKeys = this.maliciousActionsMap.getKeysForRange(startHash, endHashExclusive);
        for (String key : maliciousActionsKeys) {
            this.clearMaliciousActions(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeRecords(int startHash, int endHashExclusive) {
        Map<String, AccountLockingService> map = instances;
        synchronized (map) {
            for (AccountLockingService instance : instances.values()) {
                instance.purge(startHash, endHashExclusive);
            }
        }
    }

    public static String buildPasswordLockingKey(String password) {
        if (password == null) {
            return null;
        }
        String passwordLockingKey = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            passwordLockingKey = Base64URL.encodeToString((byte[])md.digest(password.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return passwordLockingKey;
    }

    public static String normalizeKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.length() > 100) {
            key = key.substring(0, 100);
        }
        return key.toLowerCase();
    }

    static {
        executorService.scheduleAtFixedRate(new AccountLockingCleanupTask(instances), 60L, 60L, TimeUnit.SECONDS);
    }

    public static class AccountLockingEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String instanceName;
        private final String key;
        private final AccountLockingState state;
        private final long timestamp;
        private final boolean isFailure;

        AccountLockingEntry(String instanceName, String key, AccountLockingState state, long timestamp, boolean isFailure) {
            this.instanceName = instanceName;
            this.key = key;
            this.state = state;
            this.timestamp = timestamp;
            this.isFailure = isFailure;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String getKey() {
            return this.key;
        }

        public AccountLockingState getState() {
            return this.state;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean isFailure() {
            return this.isFailure;
        }
    }

    private static class AccountLockingState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long lockExpiry;
        private LinkedList<Long> failures = new LinkedList();
        private int lockoutPeriod = AccountLockingService.getLockoutPeriod();

        public AccountLockingState() {
        }

        public AccountLockingState(AccountLockingState other) {
            this.lockExpiry = other.lockExpiry;
            this.lockoutPeriod = other.lockoutPeriod;
            if (this.failures != null) {
                this.failures = new LinkedList<Long>(other.failures);
            }
        }

        public void addFailure(long timestamp) {
            this.failures.add(timestamp);
        }

        public int getFailureCount() {
            return this.failures.size();
        }

        public void deleteFailuresOlderThan(long timestamp) {
            this.failures.removeIf(failureTimestamp -> failureTimestamp <= timestamp);
            if (this.failures.isEmpty()) {
                this.lockExpiry = 0L;
            }
        }

        public long getLockExpiry() {
            return this.lockExpiry;
        }

        public void setLockExpiry(long lockExpiry) {
            this.lockExpiry = lockExpiry;
        }

        public int getLockoutPeriod() {
            return this.lockoutPeriod;
        }

        public void setLockoutPeriod(int lockoutPeriod) {
            this.lockoutPeriod = lockoutPeriod;
        }
    }

    static class AccountLockingCleanupTask
    implements Runnable {
        private static final short CLEANUP_CHUNK_SIZE = 500;
        private final Map<String, AccountLockingService> instances;

        public AccountLockingCleanupTask(Map<String, AccountLockingService> instances) {
            this.instances = instances;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashSet<String> alsInstanceNames;
                long currentTime = this.getCurrentTimeMillis();
                Map<String, AccountLockingService> map = this.instances;
                synchronized (map) {
                    alsInstanceNames = new HashSet<String>(this.instances.keySet());
                }
                for (String alsInstanceName : alsInstanceNames) {
                    AccountLockingService alsInstance = this.instances.get(alsInstanceName);
                    int preFailureCount = alsInstance.getFailureMapSize();
                    int preMaliciousActionsCount = alsInstance.getMaliciousActionsMapSize();
                    boolean failureMapClean = false;
                    if (alsInstance.getFailureMapSize() == 0 && alsInstance.getMaliciousActionsMapSize() == 0) continue;
                    MutableInt index = new MutableInt();
                    while (true) {
                        AccountLockingService accountLockingService = alsInstance;
                        synchronized (accountLockingService) {
                            if (!failureMapClean) {
                                if (!this.cleanupChunk(alsInstance.failureMap, currentTime, index)) {
                                    failureMapClean = true;
                                    index.setValue(0);
                                }
                            } else if (!this.cleanupChunk(alsInstance.maliciousActionsMap, currentTime, index)) {
                                break;
                            }
                        }
                    }
                    int failureCountCleaned = preFailureCount - alsInstance.getFailureMapSize();
                    int maliciousActionsCleaned = preMaliciousActionsCount - alsInstance.getMaliciousActionsMapSize();
                    log.debug((Object)String.format("Cleaning instances for %s. %s failed login keys cleaned out of %s. %s malicious actions cleaned out of %s.", alsInstanceName, failureCountCleaned, preFailureCount, maliciousActionsCleaned, preMaliciousActionsCount));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while cleaning Account Locking Service", (Throwable)e);
                throw e;
            }
        }

        private boolean cleanupChunk(Map<String, AccountLockingState> map, long currentTime, MutableInt currentIndex) {
            int skipIndex = 0;
            int chunkCounter = 0;
            Iterator<Map.Entry<String, AccountLockingState>> alsIt = map.entrySet().iterator();
            ArrayList<String> keysToBeRemoved = new ArrayList<String>();
            int processedEntries = 0;
            while (alsIt.hasNext()) {
                Map.Entry<String, AccountLockingState> entry = alsIt.next();
                AccountLockingState lockingState = entry.getValue();
                if (skipIndex < currentIndex.intValue()) {
                    ++skipIndex;
                    continue;
                }
                long lockoutPeriodMillis = (long)lockingState.getLockoutPeriod() * 60L * 1000L;
                lockingState.deleteFailuresOlderThan(currentTime - lockoutPeriodMillis);
                chunkCounter = (short)(chunkCounter + 1);
                if (lockingState.getFailureCount() == 0) {
                    keysToBeRemoved.add(entry.getKey());
                } else {
                    ++processedEntries;
                }
                if (chunkCounter != 500) continue;
                break;
            }
            currentIndex.add(processedEntries);
            for (String key : keysToBeRemoved) {
                map.remove(key);
            }
            return alsIt.hasNext();
        }

        long getCurrentTimeMillis() {
            return System.currentTimeMillis();
        }
    }
}

