/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.security;

import java.util.Hashtable;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class KerberosConfigurationProvider
extends Configuration {
    private String name;
    private AppConfigurationEntry[] entries = null;

    public KerberosConfigurationProvider(String name, String debug) {
        this.name = name;
        String javaVendor = System.getProperty("java.vendor");
        boolean isSun = true;
        if (javaVendor != null && javaVendor.indexOf("IBM") >= 0) {
            isSun = false;
        }
        this.entries = new AppConfigurationEntry[1];
        Hashtable<String, String> map = new Hashtable<String, String>();
        if (isSun) {
            map.put("storeKey", String.valueOf(true));
            map.put("debug", debug != null ? debug : String.valueOf(false));
            map.put("refreshKrb5Config", String.valueOf(true));
            this.entries[0] = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map);
        } else {
            map.put("credsType", "acceptor");
            map.put("debug", debug != null ? debug : String.valueOf(false));
            map.put("refreshKrb5Config", String.valueOf(false));
            this.entries[0] = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map);
        }
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        if (name == null || !name.equals(this.name)) {
            return null;
        }
        return this.entries;
    }

    @Override
    public void refresh() {
    }
}

