/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNioFileWatcher
implements Runnable {
    private Log log = LogFactory.getLog(this.getClass());
    private File file;
    private boolean recursive;
    private boolean includeDirTimestamps;
    private boolean includeHiddenFiles;
    private WatchService watcher;
    private Map<WatchKey, Path> watchKeys;

    public AbstractNioFileWatcher(File file) {
        this(file, false, true, false);
    }

    public AbstractNioFileWatcher(Path path) {
        this(path, false, true, false);
    }

    public AbstractNioFileWatcher(File file, boolean recursive, boolean includeDirTimestamps, boolean includeHiddenFiles) {
        this.file = file;
        this.recursive = recursive;
        this.includeDirTimestamps = includeDirTimestamps;
        this.includeHiddenFiles = includeHiddenFiles;
    }

    public AbstractNioFileWatcher(Path path, boolean recursive, boolean includeDirTimestamps, boolean includeHiddenFiles) {
        this.file = path.toFile();
        this.recursive = recursive;
        this.includeDirTimestamps = includeDirTimestamps;
        this.includeHiddenFiles = includeHiddenFiles;
    }

    private void register(Path dir) {
        try {
            if (!this.getExcludedFiles().contains(dir.toFile())) {
                this.log.debug((Object)("Installing configuration file watcher for " + dir.toAbsolutePath()));
                WatchKey watchKey = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.watchKeys.put(watchKey, dir);
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Error setting up to watch for configuration file changes.", (Throwable)e);
            return;
        }
    }

    private void registerRecursive(Path dir) throws IOException {
        Files.walkFileTree(this.getFile().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (AbstractNioFileWatcher.this.getExcludedFiles().contains(dir.toFile())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                AbstractNioFileWatcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.watchKeys = new HashMap<WatchKey, Path>();
            if (this.recursive) {
                this.registerRecursive(this.getFile().toPath());
            } else {
                this.register(this.getFile().toPath());
            }
            Set<File> excludedFiles = this.getExcludedFiles();
            block16: while (true) {
                WatchKey watchKey;
                try {
                    watchKey = this.watcher.take();
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)"Configuration file watcher interrupted and exiting.");
                    try {
                        if (this.watcher == null) return;
                        this.watcher.close();
                        this.watcher = null;
                        return;
                    }
                    catch (IOException e2) {
                        this.log.error((Object)e2);
                    }
                    return;
                }
                Path dir = this.watchKeys.get(watchKey);
                Iterator<WatchEvent<?>> iterator = watchKey.pollEvents().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block16;
                    WatchEvent<?> event = iterator.next();
                    WatchEvent.Kind<?> kind = event.kind();
                    Path eventPath = (Path)event.context();
                    Path targetPath = dir.resolve(eventPath);
                    File targetFile = targetPath.toFile();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.log.debug((Object)("Overflow message received for modified file, ignoring: " + targetFile.getAbsolutePath()));
                        continue;
                    }
                    if (excludedFiles.contains(targetFile)) {
                        this.log.debug((Object)("Excluded configuration file was modified, ignoring: " + targetFile.getAbsolutePath()));
                        continue;
                    }
                    if (!this.includeHiddenFiles && targetFile.exists() && targetFile.isHidden()) {
                        this.log.debug((Object)("Hidden configuration file was modified, ignoring: " + targetFile.getAbsolutePath()));
                        continue;
                    }
                    if (this.recursive && kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        try {
                            if (Files.isDirectory(targetPath, LinkOption.NOFOLLOW_LINKS)) {
                                this.registerRecursive(targetPath);
                            }
                        }
                        catch (IOException e) {
                            this.log.error((Object)("Error watching new directory " + targetFile.getAbsolutePath() + "."), (Throwable)e);
                        }
                    }
                    this.fileChanged(targetFile, event);
                    boolean valid = watchKey.reset();
                    if (valid) continue;
                    this.watchKeys.remove(watchKey);
                    if (this.watchKeys.isEmpty()) break;
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error watching for file changes.", (Throwable)e);
            return;
        }
        finally {
            try {
                if (this.watcher != null) {
                    this.watcher.close();
                    this.watcher = null;
                }
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        }
    }

    public final File getFile() {
        return this.file;
    }

    public Set<File> getExcludedFiles() {
        return new LinkedHashSet<File>();
    }

    public boolean isIncludeDirTimestamps() {
        return this.includeDirTimestamps;
    }

    protected abstract void fileChanged(File var1, WatchEvent<?> var2);
}

